/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.BounceletGraph;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.GraphListener;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.Transaction;
import org.corebounce.decklight.bouncelets.BounceletLibrary;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.play.PlayStateChangeListener;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.utils.Log;
import org.corebounce.utils.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decklight
implements Connector,
GraphListener {
    public static final int VERSION = 4;
    public static final int REVISION = 0;
    private final BounceletGraph graph;
    private BounceletLibrary library;
    private final Collection<GraphListener> listeners = new ArrayList<GraphListener>();
    private final Map<Integer, MacroBouncelet> partContainers = new HashMap<Integer, MacroBouncelet>();
    private Transaction transaction = null;

    public Decklight() {
        this(false);
    }

    public Decklight(boolean manual) {
        this.graph = new BounceletGraph(manual);
        this.graph.addGraphListener(this);
    }

    public synchronized Map<String, BounceletBase> getBounceletTypes() {
        if (this.library == null) {
            this.library = new BounceletLibrary();
        }
        return this.library.getBouncelets();
    }

    public long getTime() {
        return this.graph.getTime();
    }

    private synchronized Transaction getTransaction() {
        if (this.transaction == null) {
            this.transaction = new Transaction();
        }
        return this.transaction;
    }

    private synchronized Transaction aquireTransaction() {
        Transaction result = this.transaction;
        this.transaction = null;
        return result;
    }

    public void addBouncelet(final BounceletBase b) {
        Transaction trx = this.getTransaction();
        trx.addAction(new Runnable(){

            public void run() {
                Decklight.this.addBouncelet0(b, b);
            }
        });
    }

    private boolean addBouncelet0(BounceletBase b, BounceletBase top) {
        boolean result = true;
        if (b instanceof Bouncelet) {
            result = this.graph.addBouncelet((Bouncelet)b);
        } else {
            assert (top instanceof MacroBouncelet);
            BounceletBase[] bounceletBaseArray = b.getParts();
            int n = bounceletBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                BounceletBase part = bounceletBaseArray[n2];
                result &= this.addBouncelet0(part, top);
                this.partContainers.put(part.getId(), (MacroBouncelet)top);
                ++n2;
            }
        }
        if (result) {
            b.createInternalConnections(this);
        }
        return result;
    }

    public <E> void addConnection(final OutputPort<? extends E> srcPort, final InputPort<E> dstPort) {
        Transaction trx = this.getTransaction();
        trx.addAction(new Runnable(){

            public void run() {
                Decklight.this.graph.addConnection(srcPort, dstPort);
            }
        });
    }

    public void addConnection(final BounceletBase srcBouncelet, final String srcPortName, final BounceletBase dstBouncelet, final String dstPortName) {
        Transaction trx = this.getTransaction();
        trx.addAction(new Runnable(){

            public void run() {
                Decklight.this.graph.addConnection(srcBouncelet, srcPortName, dstBouncelet, dstPortName);
            }
        });
    }

    @Override
    public <E> void connect(OutputPort<? extends E> srcPort, InputPort<E> dstPort) {
        this.graph.connect(srcPort, dstPort);
    }

    public void removeConnection(final OutputPort<?> srcPort, final InputPort<?> dstPort) {
        Transaction trx = this.getTransaction();
        trx.addAction(new Runnable(){

            public void run() {
                Decklight.this.graph.removeConnection(srcPort, dstPort);
            }
        });
    }

    public void removeBouncelet(final BounceletBase b) {
        Transaction trx = this.getTransaction();
        trx.addAction(new Runnable(){

            public void run() {
                Decklight.this.removeBouncelet0(b, b);
            }
        });
    }

    private void removeBouncelet0(BounceletBase b, BounceletBase top) {
        if (b instanceof Bouncelet) {
            this.graph.removeBouncelet((Bouncelet)b);
        } else {
            assert (top instanceof MacroBouncelet);
            BounceletBase[] bounceletBaseArray = b.getParts();
            int n = bounceletBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                BounceletBase part = bounceletBaseArray[n2];
                this.partContainers.remove(part.getId());
                this.removeBouncelet0(part, top);
                ++n2;
            }
        }
    }

    public <E> void setInput(final InputPort<E> port, final E value) {
        if (value != null && !port.getDataType().isInstance(value)) {
            throw new ClassCastException("Cannot set value " + value + " on port " + port + " of type " + port.getDataType());
        }
        Transaction trx = this.getTransaction();
        trx.addAction(new Runnable(){

            public void run() {
                port.write(value);
                Decklight.this.graph.inputUpdated(port);
            }
        });
    }

    public void setPlayState(PlayState playState, long when) {
        this.setPlayState(playState, when, null);
    }

    public void setPlayState(final PlayState playState, final long when, final Runnable callback) {
        Transaction trx = this.getTransaction();
        trx.addAction(new Runnable(){

            public void run() {
                Decklight.this.graph.setPlayState(playState, when, callback);
            }
        });
    }

    public void commit(long when) {
        Transaction trx = this.aquireTransaction();
        if (trx == null) {
            return;
        }
        trx.setTime(when);
        this.graph.enqueueTransaction(trx);
    }

    public void commit() {
        Transaction trx = this.aquireTransaction();
        if (trx == null) {
            return;
        }
        this.graph.executeTransaction(trx);
    }

    public void dispose() {
        this.graph.removeGraphListener(this);
        this.graph.dispose();
    }

    public void reset() {
        this.graph.reset();
    }

    public void cycleManual() {
        this.graph.cycleManual();
    }

    public void addPlayStateChangeListener(PlayStateChangeListener listener) {
        this.graph.addPlayStateChangeListener(listener);
    }

    public void removePlayStateChangeListener(PlayStateChangeListener listener) {
        this.graph.removePlayStateChangeListener(listener);
    }

    public void addGraphListener(GraphListener listener) {
        this.listeners.add(listener);
    }

    public void removeGraphListener(GraphListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void logMessage(GraphErrorType errorType, Severity severity, String message, Object source) {
        for (GraphListener listener : this.listeners) {
            listener.logMessage(errorType, severity, message, source);
        }
    }

    @Override
    public void portValueChanged(int bounceletId, int portNum, boolean output, Object value) {
        MacroBouncelet macro = this.partContainers.get(bounceletId);
        if (macro != null) {
            Bouncelet b = this.graph.getBounceletById(bounceletId);
            if (b != null) {
                int mPortNum;
                Port port;
                if (output) {
                    port = b.getOutputPorts().get(portNum);
                    mPortNum = macro.getOutputPorts().indexOf(port);
                } else {
                    port = b.getInputPorts().get(portNum);
                    mPortNum = macro.getInputPorts().indexOf(port);
                }
                if (mPortNum >= 0) {
                    bounceletId = macro.getId();
                    portNum = mPortNum;
                }
            } else {
                Log.debug("Bouncelet not found: {0}", bounceletId);
            }
        }
        for (GraphListener listener : this.listeners) {
            listener.portValueChanged(bounceletId, portNum, output, value);
        }
    }
}

