/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Port<E> {
    private final Class<E> dataType;
    private final String name;
    private final String description;
    private ScaleType scaleType = ScaleType.LINEAR;
    private SkillType skillType = SkillType.NORMAL;
    private Bouncelet owner;
    private boolean isModified;
    protected E data;

    protected Port(Class<E> dataType, String name, String description) {
        this.dataType = dataType;
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<E> getDataType() {
        return this.dataType;
    }

    public ScaleType getScaleType() {
        return this.scaleType;
    }

    public void setScaleType(ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    public SkillType getSkillType() {
        return this.skillType;
    }

    public void setSkillType(SkillType skillType) {
        this.skillType = skillType;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void clear() {
        this.data = null;
        this.setModified(false);
    }

    void set(E data) {
        this.data = data;
        this.setModified(true);
    }

    public void setModified(boolean value) {
        this.isModified = value;
    }

    public void sourceChanged() {
        this.setModified(true);
    }

    public static <E> void transfer(InputPort<E> srcPort, OutputPort<E> dstPort) {
        if (srcPort.isModified()) {
            dstPort.data = srcPort.read();
            dstPort.setModified(true);
        } else {
            dstPort.setModified(false);
        }
    }

    public boolean isInput() {
        return this instanceof InputPort;
    }

    public boolean isOutput() {
        return this instanceof OutputPort;
    }

    public BounceletBase getOwner() {
        return this.owner;
    }

    public Bouncelet getBouncelet() {
        return this.owner;
    }

    void setOwner(Bouncelet owner) {
        this.owner = owner;
    }

    public String toString() {
        if (this.owner == null) {
            return "<null>:" + this.name;
        }
        return String.valueOf(this.owner.toString()) + ":" + this.name;
    }
}

