/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.BounceletGraph;
import org.corebounce.decklight.CycleAction;
import org.corebounce.decklight.CycleException;
import org.corebounce.decklight.FlowEngine;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.Transaction;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.play.EndingSourceBouncelet;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.play.PlayStateBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;
import org.corebounce.utils.Clock;
import org.corebounce.utils.Log;
import org.corebounce.utils.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler
extends Thread
implements FlowEngine {
    private static final String OVERRUN_MESSAGE = "Sorry Prof. Drake, I couldn't finish my homework.";
    private static final long DEFAULT_CYCLE_SPEED = 20000000L;
    private final BounceletGraph graph;
    private final String name;
    private Set<Bouncelet> bouncelets = new LinkedHashSet<Bouncelet>();
    private Set<Bouncelet> targets = new LinkedHashSet<Bouncelet>();
    private Set<Bouncelet> sinks = new LinkedHashSet<Bouncelet>();
    private Set<PlayStateBouncelet> playStateBouncelets = new LinkedHashSet<PlayStateBouncelet>();
    private Set<EndingSourceBouncelet> endingBouncelets = new LinkedHashSet<EndingSourceBouncelet>();
    private Clock clock;
    private PriorityQueue<CycleAction> processes;
    private List<CycleAction> ready;
    private boolean isInterrupted = false;
    private Thread overrunDetector = null;
    private long overrunThreadTime = 0L;
    private PriorityQueue<Transaction> transactions = new PriorityQueue();
    private Queue<Runnable> commands = new LinkedList<Runnable>();
    private boolean isClearTimingCacheRequired = false;
    private boolean isRescheduleRequired = false;
    private volatile Fraction time = new Fraction(0L);
    private int stdPriority = Integer.MIN_VALUE;
    private PlayState curPlayState = PlayState.STOP;
    private PlayState nextPlayState = PlayState.STOP;
    private long nextStateTime = -1L;
    private Runnable playStateCallback = null;
    private Object playStateLock = new Object();
    private PlayState notifyState = null;
    private long notifyTime = -1L;
    private boolean stopped = true;
    private Fraction newRate = new Fraction();

    public Scheduler(BounceletGraph graph, String name) {
        super(name);
        this.graph = graph;
        this.name = name;
    }

    public BounceletGraph getGraph() {
        return this.graph;
    }

    public long getTime() {
        return this.time.floor();
    }

    void addBouncelet(Bouncelet b) {
        this.bouncelets.add(b);
        assert (b.scheduler == null);
        b.scheduler = this;
        b.setInpRate(b.cycleSpeed());
        b.resetLatency();
        if (b.isTarget()) {
            this.targets.add(b);
            if (this.processes != null) {
                Fraction when = this.time;
                if (!this.processes.isEmpty()) {
                    when = this.processes.peek().getTime();
                }
                this.processes.add(new CycleAction(b, when));
            }
        }
        if (b.isSink()) {
            this.sinks.add(b);
        }
        if (b instanceof PlayStateBouncelet) {
            this.playStateBouncelets.add((PlayStateBouncelet)((Object)b));
            ((PlayStateBouncelet)((Object)b)).setPlayState(this.curPlayState, this.time.floor());
        }
        if (b instanceof EndingSourceBouncelet) {
            this.endingBouncelets.add((EndingSourceBouncelet)((Object)b));
        }
    }

    void removeBouncelet(Bouncelet b) {
        if (b instanceof EndingSourceBouncelet) {
            this.endingBouncelets.remove((EndingSourceBouncelet)((Object)b));
        }
        if (b instanceof PlayStateBouncelet) {
            this.playStateBouncelets.remove((PlayStateBouncelet)((Object)b));
        }
        if (b.isSink()) {
            this.sinks.remove(b);
        }
        if (b.isTarget()) {
            if (this.processes != null) {
                Iterator<CycleAction> iter = this.processes.iterator();
                while (iter.hasNext()) {
                    CycleAction action = iter.next();
                    if (!action.getTarget().equals(b)) continue;
                    iter.remove();
                }
            }
            this.targets.remove(b);
        }
        this.bouncelets.remove(b);
        b.scheduler = null;
        this.planClearTimingCaches();
    }

    void inputUpdated(InputPort<?> port) {
        if (port.isSpeedModifier() || this.graph.getFirstSpeedModifierDownwards(port.getBouncelet()) != null) {
            this.planReschedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueTransaction(Transaction trx) {
        PriorityQueue<Transaction> priorityQueue = this.transactions;
        synchronized (priorityQueue) {
            this.transactions.add(trx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueImmediateCommand(Runnable command) {
        Queue<Runnable> queue = this.commands;
        synchronized (queue) {
            this.commands.add(command);
        }
    }

    synchronized void setOverrunDetectionEnabled(boolean value) {
        if (value) {
            if (this.overrunDetector == null) {
                this.overrunDetector = new Thread("Overrun detector"){

                    /*
                     * Unable to fully structure code
                     */
                    public void run() {
                        try {
                            Thread.sleep(3000L);
                            if (true) ** GOTO lbl13
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                        do {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                break;
                            }
                            Scheduler.access$1(Scheduler.this, System.currentTimeMillis());
lbl13:
                            // 2 sources

                        } while (Scheduler.access$0(Scheduler.this) != null);
                    }
                };
                this.overrunThreadTime = System.currentTimeMillis() + 3000L;
                this.overrunDetector.start();
            }
        } else if (this.overrunDetector != null) {
            Thread t = this.overrunDetector;
            this.overrunDetector = null;
            t.interrupt();
            try {
                t.join(2000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean isStopping() {
        return this.curPlayState.equals((Object)PlayState.STOP) || PlayState.STOP.equals((Object)this.nextPlayState);
    }

    private void detectOverrun() {
        if (this.overrunDetector == null || this.isStopping()) {
            return;
        }
        if (this.overrunThreadTime + 4000L < System.currentTimeMillis()) {
            this.graph.logMessage(GraphErrorType.ServerOverrun, Severity.Error, this.graph, OVERRUN_MESSAGE, new Object[0]);
            this.setPlayState(PlayState.STOP, 0L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPlayState(PlayState playState, long when, Runnable callback) {
        assert (when >= 0L);
        Object object = this.playStateLock;
        synchronized (object) {
            this.nextPlayState = playState;
            this.nextStateTime = when;
            this.playStateCallback = callback;
        }
    }

    private void switchToStandardPriority() {
        if (this.stdPriority != Integer.MIN_VALUE) {
            Thread.currentThread().setPriority(this.stdPriority);
            this.stdPriority = Integer.MIN_VALUE;
        }
    }

    private void switchToBackgroundPriority() {
        if (this.stdPriority == Integer.MIN_VALUE) {
            this.stdPriority = Thread.currentThread().getPriority();
            int bckPriority = 2;
            Thread.currentThread().setPriority(bckPriority);
        }
    }

    synchronized void finish() {
        Log.debug("Scheduler \"{0}\" stopping...", this.name);
        this.setOverrunDetectionEnabled(false);
        this.isInterrupted = true;
    }

    @Override
    public void run() {
        Log.debug("Scheduler \"{0}\" starting...", this.name);
        this.switchToStandardPriority();
        while (!this.isInterrupted) {
            this.cycle();
        }
        this.switchToStandardPriority();
    }

    protected void cycle() {
        this.pollTransactions();
        this.pollCommands();
        if (this.isClearTimingCacheRequired) {
            this.clearTimingCaches();
        }
        this.handlePlayState();
        if (this.isRescheduleRequired) {
            this.reschedule();
        }
        this.setupProcesses();
        if (this.handleEmptyCase()) {
            return;
        }
        CycleType cycleType = this.createReadyActionsList();
        this.waitForReadyActionsTime(cycleType);
        this.performReadyActions(cycleType);
        if (cycleType != CycleType.NON_REALTIME) {
            this.detectOverrun();
        } else {
            Thread.yield();
        }
    }

    public void reset() {
        this.clearTimingCaches();
        this.reschedule();
        this.processes = new PriorityQueue();
        for (Bouncelet b : this.targets) {
            CycleAction action = new CycleAction(b, this.time);
            this.processes.add(action);
        }
        this.ready = new ArrayList<CycleAction>(this.processes.size());
    }

    public void cycleManual() throws CycleException {
        this.pollCommands();
        this.ready.clear();
        CycleAction todo = this.processes.peek();
        if (todo.getTime().compareTo(this.time) < 0) assert (false) : "An action has been missed and is now in the past";
        this.time.set(todo.getTime());
        while (todo != null && todo.getTime().equals(this.time)) {
            todo = (CycleAction)this.processes.remove();
            this.ready.add(todo);
            todo = this.processes.peek();
        }
        int i = 0;
        while (i < this.ready.size()) {
            CycleAction action = this.ready.get(i);
            assert (action.getTime().equals(this.time)) : "Sync error";
            Bouncelet b = action.getTarget();
            try {
                this.cycleRecursive(b);
                Fraction cycleRate = b.getInpRate();
                if (cycleRate != null) {
                    action.setNextTime(cycleRate);
                    this.processes.add(action);
                } else if (b.isTarget() || this.graph.isCycling(b)) {
                    Fraction dfltRate = new Fraction(AudioConfig.blockSize());
                    b.setInpRate(dfltRate);
                    action.setNextTime(dfltRate);
                    this.processes.add(action);
                } else {
                    Log.debug("Removing from scheduler: {0}", b);
                }
            }
            catch (CycleException ex) {
                throw ex;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollTransactions() {
        PriorityQueue<Transaction> priorityQueue = this.transactions;
        synchronized (priorityQueue) {
            while (!this.transactions.isEmpty() && this.transactions.peek().getTime() <= (double)this.time.floor()) {
                Transaction trx = this.transactions.poll();
                this.graph.executeTransaction(trx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollCommands() {
        Queue<Runnable> queue = this.commands;
        synchronized (queue) {
            Runnable transaction = this.commands.poll();
            while (transaction != null) {
                transaction.run();
                Runnable runnable = transaction;
                synchronized (runnable) {
                    transaction.notifyAll();
                }
                transaction = this.commands.poll();
            }
        }
    }

    private long samples2nano(long value) {
        return value * 1000000000L / (long)AudioConfig.getSampleRate();
    }

    private long nano2samples(long value) {
        return value * (long)AudioConfig.getSampleRate() / 1000000000L;
    }

    private void setupProcesses() {
        if (this.clock == null) {
            this.clock = new Clock(this.samples2nano(this.time.floor()));
        }
        if (this.processes == null) {
            this.processes = new PriorityQueue();
            for (Bouncelet b : this.targets) {
                CycleAction action = new CycleAction(b, this.time);
                this.processes.add(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePlayState() {
        Object object = this.playStateLock;
        synchronized (object) {
            this.notifyPendingPlayStateChangeRequests();
            this.handleEndOfStreams();
            this.handlePlayStateChanges();
        }
    }

    private void notifyPendingPlayStateChangeRequests() {
        if (this.notifyTime >= 0L && this.getTime() >= this.notifyTime) {
            this.graph.stateChangedTo(this.notifyState, this.notifyTime);
            this.notifyTime = -1L;
        }
    }

    private void handleEndOfStreams() {
        boolean isUnfinished = false;
        if (this.curPlayState == PlayState.PLAY) {
            long stopTime = -1L;
            for (EndingSourceBouncelet b : this.endingBouncelets) {
                long when = b.getEndTime();
                if (when < 0L) {
                    isUnfinished = true;
                    continue;
                }
                if (stopTime >= 0L && when <= stopTime) continue;
                stopTime = when;
            }
            if (!isUnfinished && stopTime >= 0L) {
                if (!this.isStopping()) {
                    Log.debug("Stopping at {0}. Current time: {1}", stopTime, this.getTime());
                }
                this.setPlayState(PlayState.STOP, stopTime, null);
            }
        }
    }

    private void handlePlayStateChanges() {
        if (this.nextPlayState != this.curPlayState) {
            if (this.nextPlayState == PlayState.PLAY) {
                boolean bl;
                boolean bl2 = true;
                for (PlayStateBouncelet b : this.playStateBouncelets) {
                    if (b.isReadyToPlay()) continue;
                    bl = false;
                }
                if (bl) {
                    this.setCurPlayState(PlayState.PLAY, this.nextStateTime);
                } else {
                    this.setCurPlayState(PlayState.PAUSE, this.nextStateTime);
                }
                for (PlayStateBouncelet b : this.playStateBouncelets) {
                    b.setPlayState(this.curPlayState, this.nextStateTime);
                }
                if (this.curPlayState == PlayState.PLAY) {
                    if (this.playStateCallback != null) {
                        this.playStateCallback.run();
                        this.playStateCallback = null;
                    }
                    this.nextStateTime = -1L;
                }
            } else if (this.nextPlayState == PlayState.STOP) {
                this.stopped = true;
                for (PlayStateBouncelet playStateBouncelet : this.playStateBouncelets) {
                    if (playStateBouncelet.isStopped()) continue;
                    playStateBouncelet.setPlayState(this.nextPlayState, this.nextStateTime);
                    if (!this.graph.isSinking((Bouncelet)((Object)playStateBouncelet))) continue;
                    this.stopped = false;
                }
                if (this.stopped) {
                    this.setCurPlayState(PlayState.STOP, this.nextStateTime);
                    for (Bouncelet bouncelet : this.bouncelets) {
                        bouncelet.resetTime();
                    }
                    if (this.playStateCallback != null) {
                        this.playStateCallback.run();
                        this.playStateCallback = null;
                    }
                    this.nextStateTime = -1L;
                }
            } else {
                for (PlayStateBouncelet playStateBouncelet : this.playStateBouncelets) {
                    playStateBouncelet.setPlayState(this.nextPlayState, this.nextStateTime);
                }
                this.setCurPlayState(this.nextPlayState, this.nextStateTime);
                if (this.playStateCallback != null) {
                    this.playStateCallback.run();
                    this.playStateCallback = null;
                }
                this.nextStateTime = -1L;
            }
        }
    }

    private void setCurPlayState(PlayState state, long when) {
        if (state != this.curPlayState) {
            if (this.curPlayState == PlayState.STOP && state != PlayState.STOP) {
                this.reschedule();
            }
            this.curPlayState = state;
            this.notifyState = state;
            this.notifyTime = when;
            if (this.curPlayState != PlayState.STOP) {
                this.stopped = false;
            }
        }
    }

    private boolean handleEmptyCase() {
        if (this.processes.isEmpty() || this.stopped) {
            long timeoutNs = this.clock.getTime() + 20000000L;
            this.clock.join(timeoutNs, true);
            this.time.set(this.nano2samples(this.clock.getTime()), 1L);
            return true;
        }
        return false;
    }

    private CycleType createReadyActionsList() {
        CycleType result = CycleType.NON_REALTIME;
        if (this.ready == null) {
            this.ready = new ArrayList<CycleAction>(this.processes.size());
        } else assert (this.ready.isEmpty()) : "cycle() is not thread-safe";
        for (CycleAction action : this.processes) {
            if (action.getTarget().isClocking()) {
                result = CycleType.EXTERNAL_CLOCK;
                continue;
            }
            if (result != CycleType.NON_REALTIME || !action.getTarget().isRealtime()) continue;
            result = CycleType.INTERNAL_CLOCK;
        }
        CycleAction todo = this.processes.peek();
        if (todo.getTime().compareTo(this.time) < 0) assert (false) : "An action has been missed and is now in the past";
        this.time.set(todo.getTime());
        while (todo != null && todo.getTime().equals(this.time)) {
            todo = (CycleAction)this.processes.remove();
            this.ready.add(todo);
            todo = this.processes.peek();
        }
        return result;
    }

    private void waitForReadyActionsTime(CycleType cycleType) {
        if (cycleType == CycleType.NON_REALTIME) {
            if (this.curPlayState == PlayState.PLAY || this.nextPlayState == PlayState.PLAY) {
                this.clock.reset(this.samples2nano(this.time.floor()));
                return;
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ex) {
                throw new InternalError("Sleep interrupted");
            }
            this.clock.reset(this.samples2nano(this.time.floor()));
            return;
        }
        boolean useInternalClock = cycleType == CycleType.INTERNAL_CLOCK;
        boolean onTime = this.clock.join(this.samples2nano(this.time.floor()), useInternalClock);
        if (!onTime && !this.isStopping()) {
            this.graph.logMessage(GraphErrorType.DeviceOverrun, Severity.Error, this.graph, OVERRUN_MESSAGE, new Object[0]);
            this.setPlayState(PlayState.STOP, 0L, null);
        }
    }

    private void performReadyActions(CycleType cycleType) {
        int i = 0;
        while (i < this.ready.size()) {
            CycleAction action = this.ready.get(i);
            assert (action.getTime().equals(this.time)) : "Sync error";
            Bouncelet b = action.getTarget();
            try {
                this.cycleRecursive(b);
                Fraction cycleRate = b.getInpRate();
                if (cycleRate != null) {
                    action.setNextTime(cycleRate);
                    this.processes.add(action);
                } else if (b.isTarget() || this.graph.isCycling(b)) {
                    Fraction inferedRate = this.inferRate(b);
                    if (inferedRate != null) {
                        b.setInpRate(inferedRate);
                        action.setNextTime(inferedRate);
                        this.processes.add(action);
                    } else if (cycleType == CycleType.NON_REALTIME) {
                        Fraction dfltRate = new Fraction(AudioConfig.blockSize());
                        b.setInpRate(dfltRate);
                        action.setNextTime(dfltRate);
                        this.processes.add(action);
                        this.graph.logMessage(GraphErrorType.Information, Severity.Info, this.graph, "Switching to non realtime mode", new Object[0]);
                        this.switchToBackgroundPriority();
                    } else if (b.isSink()) {
                        this.graph.logMessage(GraphErrorType.Information, Severity.Warning, b, "Sink {0} is unreachable and will not run", b);
                    }
                } else {
                    Log.debug("Removing from scheduler: {0}", b);
                }
            }
            catch (CycleException ex) {
                ex.getCause().printStackTrace();
                this.setPlayState(PlayState.STOP, this.getTime(), null);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.graph.logMessage(GraphErrorType.ServerError, Severity.Catastroph, b, "An exception occured while cycling the graph from {0}:\n{1}", b, t);
                this.setPlayState(PlayState.STOP, this.getTime(), null);
            }
            ++i;
        }
        this.ready.clear();
    }

    private void cycleRecursive(Bouncelet b) {
        if (b.getTime() >= this.time.floor()) {
            return;
        }
        b.setTime(this.time.floor());
        Fraction rtRate = b.cycleSpeed();
        if (rtRate != null) {
            b.setInpRate(rtRate);
        }
        try {
            b.fullCycle(this);
            b.latencyUpdated();
        }
        catch (CycleException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.graph.logMessage(GraphErrorType.ServerError, Severity.Catastroph, b, "An exception occured while cycling {0}:\n{1}", b, t);
            throw new CycleException(b, t);
        }
    }

    private Fraction inferRate(Bouncelet b) {
        HashMap<Bouncelet, Fraction> rates = new HashMap<Bouncelet, Fraction>();
        LinkedList<Bouncelet> todo = new LinkedList<Bouncelet>();
        LinkedHashSet<Bouncelet> rated = new LinkedHashSet<Bouncelet>(this.targets);
        rated.addAll(this.sinks);
        for (Bouncelet target : rated) {
            Fraction rate;
            if (rates.containsKey(target) || (rate = target.getInpRate()) == null) continue;
            rates.put(target, rate);
            todo.offer(target);
        }
        while (!todo.isEmpty()) {
            Bouncelet next = (Bouncelet)todo.poll();
            Fraction rate = (Fraction)rates.get(next);
            assert (rate != null);
            Map<InputPort<?>, OutputPort<?>> connections = this.graph.getOutputConnections(next);
            for (InputPort<?> inputPort : connections.keySet()) {
                Bouncelet down = inputPort.getBouncelet();
                if (rates.containsKey(down)) continue;
                Fraction downRate = Fraction.prod(rate, next.timeSkew());
                rates.put(down, downRate);
                todo.offer(down);
            }
            for (InputPort<?> inputPort : next.getInputPorts()) {
                Bouncelet up;
                OutputPort<?> outputPort = inputPort.getSource();
                if (outputPort == null || rates.containsKey(up = outputPort.getBouncelet())) continue;
                Fraction upRate = Fraction.quo(rate, up.timeSkew());
                rates.put(up, upRate);
                todo.offer(up);
            }
        }
        if (rates.containsKey(b)) {
            return (Fraction)rates.get(b);
        }
        return null;
    }

    @Override
    public void requestData(InputPort<?> inputPort) {
        Bouncelet bouncelet = inputPort.getBouncelet();
        OutputPort<?> srcPort = inputPort.getSource();
        if (srcPort == null) {
            return;
        }
        Bouncelet source = srcPort.getBouncelet();
        if (!srcPort.isManual()) {
            this.cycleRecursive(source);
        }
        if (!srcPort.isReady()) {
            if (!this.isStopping()) {
                this.graph.logMessage(GraphErrorType.ServerError, Severity.Error, srcPort, "Port is not ready: {0}. Target: {1}", srcPort, inputPort);
                this.setPlayState(PlayState.STOP, 0L, null);
            }
            return;
        }
        inputPort.readFromSource();
        if (source.isInpRateKnown()) {
            Fraction skew = source.timeSkew();
            this.newRate.set(source.getInpRate());
            this.newRate.mulFast(skew);
            assert (this.newRate.isStrictlyPositive());
            if (!bouncelet.isInpRateKnown()) {
                bouncelet.setInpRate(this.newRate);
            } else if (!bouncelet.getInpRate().equals(this.newRate) && !this.isStopping()) {
                this.graph.logMessage(GraphErrorType.ClockSkew, Severity.Error, bouncelet, "Clock skew at {0}. Previous rate: {1}, rate inferred by {2}: {3}", bouncelet, bouncelet.getInpRate(), source, this.newRate);
                this.setPlayState(PlayState.STOP, 0L, null);
            }
        }
        if (bouncelet.isLatencyDirty()) {
            int latency;
            boolean isMinDefined = true;
            int min = latency = source.getLatency();
            int minSrcLatency = source.getMinInLatency();
            if (minSrcLatency != -1) {
                min += minSrcLatency;
            } else {
                isMinDefined = false;
            }
            if (isMinDefined && (bouncelet.getMinInLatency() == -1 || min > bouncelet.getMinInLatency())) {
                bouncelet.setMinInLatency(min);
            }
            boolean isMaxDefined = true;
            int max = latency;
            int maxSrcLatency = source.getMaxInLatency();
            if (maxSrcLatency != -1) {
                max += maxSrcLatency;
            } else {
                isMaxDefined = false;
            }
            if (isMaxDefined && (bouncelet.getMaxInLatency() == -1 || max > bouncelet.getMaxInLatency())) {
                bouncelet.setMaxInLatency(max);
            }
        }
    }

    void planClearTimingCaches() {
        this.isClearTimingCacheRequired = true;
    }

    void planReschedule() {
        if (this.curPlayState != PlayState.STOP) {
            this.isRescheduleRequired = true;
        }
    }

    private void clearTimingCaches() {
        this.isClearTimingCacheRequired = false;
        for (Bouncelet b : this.bouncelets) {
            b.resetLatency();
        }
    }

    private void reschedule() {
        this.isRescheduleRequired = false;
        this.graph.logMessage(GraphErrorType.ClockSkew, Severity.Debug, this.graph, "Speed change detected. Rebuilding scheduler", new Object[0]);
        this.processes = null;
        this.clock = null;
        for (Bouncelet b : this.bouncelets) {
            b.reset();
            b.resetTime();
            b.resetLatency();
        }
    }

    static /* synthetic */ Thread access$0(Scheduler scheduler) {
        return scheduler.overrunDetector;
    }

    static /* synthetic */ void access$1(Scheduler scheduler, long l) {
        scheduler.overrunThreadTime = l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CycleType {
        EXTERNAL_CLOCK,
        INTERNAL_CLOCK,
        NON_REALTIME;

    }
}

