/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.audio.convert;

public class Resampler {
    private final Source source;
    private final double revRatio;
    private final int nbChans;
    private float[][] input;
    private int intPos;
    private double fracPos;

    public Resampler(Source source, double ratio, int nbChans) {
        this.source = source;
        this.revRatio = 1.0 / ratio;
        this.nbChans = nbChans;
    }

    public void resample(float[][] output) {
        if (output.length != this.nbChans) {
            throw new IllegalArgumentException("The number of channels does not match. Expected: " + this.nbChans + "; supplied: " + output.length);
        }
        int nbFrames = output[0].length;
        double[] outSamples = new double[this.nbChans];
        int i = 0;
        while (i < nbFrames) {
            int chan = 0;
            while (chan < this.nbChans) {
                outSamples[chan] = 0.0;
                ++chan;
            }
            double toAdd = this.revRatio;
            while (toAdd > 0.0) {
                double avail = 1.0 - this.fracPos;
                double doAdd = toAdd > avail ? avail : toAdd;
                this.ensureData();
                int chan2 = 0;
                while (chan2 < this.nbChans) {
                    int n = chan2;
                    outSamples[n] = outSamples[n] + (double)this.input[chan2][this.intPos] * doAdd;
                    ++chan2;
                }
                this.fracPos += doAdd;
                if (this.fracPos >= 1.0) {
                    assert (this.fracPos == 1.0);
                    this.fracPos -= 1.0;
                    ++this.intPos;
                }
                toAdd -= doAdd;
            }
            int chan3 = 0;
            while (chan3 < this.nbChans) {
                output[chan3][i] = (float)(outSamples[chan3] / this.revRatio);
                ++chan3;
            }
            ++i;
        }
    }

    private void ensureData() {
        while (this.input == null || this.intPos >= this.input[0].length) {
            assert (this.fracPos == 0.0);
            this.input = this.source.getNextBlock();
            if (this.input.length != this.nbChans) {
                throw new IllegalArgumentException("The number of channels does not match. Expected: " + this.nbChans + "; supplied: " + this.input.length);
            }
            this.intPos = 0;
        }
    }

    public double getRatio() {
        return 1.0 / this.revRatio;
    }

    public static interface Source {
        public float[][] getNextBlock();
    }
}

