/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.audio.device;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.EnumControl;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import org.corebounce.common.gui.Console;

public class JavaSoundDump {
    public static void main(String[] args) {
        Mixer.Info[] mixerInfos;
        Console.redirectStdOutAndStdErr(true);
        Mixer.Info[] infoArray = mixerInfos = AudioSystem.getMixerInfo();
        int n = mixerInfos.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info mixerInfo = infoArray[n2];
            System.out.println("Mixer: " + mixerInfo);
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            try {
                mixer.open();
                Line.Info[] lineInfos = mixer.getSourceLineInfo();
                JavaSoundDump.dumpLineInfos(mixer, lineInfos, "Output", "Capture");
                lineInfos = mixer.getTargetLineInfo();
                JavaSoundDump.dumpLineInfos(mixer, lineInfos, "Input", "Playback");
            }
            catch (LineUnavailableException ex) {
                System.out.println(" *** Mixer not available");
            }
            mixer.close();
            ++n2;
        }
    }

    private static void dumpLineInfos(Mixer mixer, Line.Info[] lineInfos, String linePrefix, String portPrefix) throws LineUnavailableException {
        Line.Info[] infoArray = lineInfos;
        int n = lineInfos.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Line.Info lineInfo = infoArray[n2];
            if (lineInfo instanceof DataLine.Info) {
                System.out.println("  " + linePrefix + " line: " + lineInfo);
                DataLine.Info dlInfo = (DataLine.Info)lineInfo;
                AudioFormat[] audioFormatArray = dlInfo.getFormats();
                n3 = audioFormatArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    AudioFormat format = audioFormatArray[n4];
                    System.out.println("    " + linePrefix + format.toString());
                    ++n4;
                }
            } else if (lineInfo instanceof Port.Info) {
                System.out.println("  " + portPrefix + " port: " + lineInfo);
            } else {
                System.out.println("  Unknown shit: " + lineInfo);
            }
            Line line = mixer.getLine(lineInfo);
            if (!(line instanceof Clip)) {
                try {
                    Control[] controls;
                    line.open();
                    Control[] controlArray = controls = line.getControls();
                    int n5 = controls.length;
                    n3 = 0;
                    while (n3 < n5) {
                        Control control = controlArray[n3];
                        JavaSoundDump.dumpControlInfo(control, "    ");
                        ++n3;
                    }
                }
                catch (LineUnavailableException ex) {
                    ex.printStackTrace();
                    System.out.println("  *** Line not available");
                }
                line.close();
            }
            ++n2;
        }
    }

    private static void dumpControlInfo(Control control, String prefix) {
        StringBuilder details = new StringBuilder();
        if (control instanceof BooleanControl) {
            details.append("boolean");
        } else if (control instanceof FloatControl) {
            details.append("float");
        } else if (control instanceof CompoundControl) {
            details.append("compound");
        } else if (control instanceof EnumControl) {
            EnumControl enumControl = (EnumControl)control;
            details.append(Arrays.toString(enumControl.getValues()));
        } else {
            details.append("unknown");
        }
        System.out.println(String.valueOf(prefix) + control.getType() + " (" + details + ") Control: " + control);
        if (control instanceof CompoundControl) {
            CompoundControl compound = (CompoundControl)control;
            Control[] controlArray = compound.getMemberControls();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                JavaSoundDump.dumpControlInfo(child, String.valueOf(prefix) + "  ");
                ++n2;
            }
        }
    }
}

