/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.audio.device;

import org.corebounce.decklight.audio.device.AudioDevice;
import org.corebounce.decklight.audio.device.AudioException;
import org.corebounce.decklight.audio.device.RtAudio;

public class RtAudioDevice
implements AudioDevice {
    private RtAudio device = new RtAudio();

    public RtAudioDevice() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                RtAudioDevice rtAudioDevice = RtAudioDevice.this;
                synchronized (rtAudioDevice) {
                    if (RtAudioDevice.this.device != null) {
                        RtAudioDevice.this.device.terminate();
                        RtAudioDevice.this.device = null;
                    }
                }
            }
        });
    }

    public synchronized void setup(int recordDeviceNum, int nbRecordChans, int playDeviceNum, int nbPlayChans, int rate, int nbFrames, int nbBuffers) throws AudioException {
        int result = this.device.setup(recordDeviceNum, nbRecordChans, playDeviceNum, nbPlayChans, rate, nbFrames, nbBuffers);
        if (result == -2) {
            throw new AudioException("Audio parameters are not supported or are different between capture and playback", new Object[0]);
        }
        if (result == -1) {
            throw new AudioException("I/O Error", new Object[0]);
        }
    }

    public synchronized void playBuffer(float[] samples, int offset, int count) throws AudioException {
        if (this.device == null) {
            throw new AudioException("Device closed", new Object[0]);
        }
        int result = this.device.playBuffer(samples, offset, count);
        if (result == -2) {
            throw new AudioException("Invalid arguments", new Object[0]);
        }
        if (result == -1) {
            throw new AudioException("I/O Error", new Object[0]);
        }
    }

    public synchronized void recordBuffer(float[] samples, int offset, int count) throws AudioException {
        if (this.device == null) {
            throw new AudioException("Device closed", new Object[0]);
        }
        int result = this.device.recordBuffer(samples, offset, count);
        if (result == -2) {
            throw new AudioException("Invalid arguments", new Object[0]);
        }
        if (result == -1) {
            throw new AudioException("I/O Error", new Object[0]);
        }
    }

    public boolean prefersRealTime() {
        return true;
    }

    public int preferredFrameSize() {
        return 1024;
    }

    public int preferredNumberOfBuffers() {
        return 3;
    }
}

