/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio;

import org.corebounce.common.math.Cmplx;

public class CmplxBuffer {
    private int size;
    private Cmplx[] values;
    private int index;

    public CmplxBuffer(int size) {
        this.size = size;
        this.values = Cmplx.newArray(size);
        this.index = 0;
    }

    public void push(Cmplx value) {
        if (this.size == 0) {
            return;
        }
        this.values[this.index].set(value);
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
    }

    public Cmplx peek() {
        return this.values[this.index];
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size == this.size) {
            return;
        }
        Cmplx[] old = this.values;
        this.size = size;
        this.values = Cmplx.newArray(size);
        int min = size < old.length ? size : old.length;
        int offset = size - min;
        int i = 0;
        while (i < min) {
            this.values[i + offset].set(old[(this.index + i) % old.length]);
            ++i;
        }
        this.index = 0;
    }
}

