/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.analysis;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.ClockData;
import org.corebounce.decklight.ports.InClock;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.OutClock;
import org.corebounce.utils.ShaolinBag;

public class BPMCalc
extends Bouncelet {
    private static final int TIME_HISTORY_SIZE = 4;
    private static final int DISTANCE_HISTORY_SIZE = 51;
    private static final double MEDIAN_PERCENTAGE = 0.2;
    public InClock inClock = new InClock("clock", "Beat clock");
    public InDouble inMinBPM = new InDouble("bpm.min", "Min BPM", 60.0, 30.0, 200.0);
    public InDouble inMaxBPM = new InDouble("bpm.max", "Max BPM", 160.0, 30.0, 200.0);
    public OutClock outBPM = new OutClock("bpm.clock", "Output BPM clock");
    private double lastTime;
    private double lastTime2;
    private double lastBPM;
    private List<Double> times;
    private Queue<Double> distancesQueue;
    private ShaolinBag<Double> distancesSorted;

    public BPMCalc() {
        super("audio.analysis.bpmcalc", "BPM estimator", true);
        super.setSkillType(SkillType.EXPERT);
    }

    public void init() {
        this.times = new ArrayList<Double>();
        this.distancesQueue = new LinkedList<Double>();
        this.distancesSorted = new ShaolinBag();
    }

    public void dispose() {
        this.times = null;
        this.distancesQueue = null;
        this.distancesSorted = null;
    }

    private void addDistance(Double distance) {
        this.distancesQueue.offer(distance);
        this.distancesSorted.add(distance);
    }

    private void removeOldDistances() {
        while (this.distancesQueue.size() > 51) {
            double oldest = this.distancesQueue.poll();
            this.distancesSorted.remove(oldest);
        }
    }

    private double makeLookSexy(double bpm) {
        double diff;
        double d = diff = this.lastBPM < bpm ? bpm - this.lastBPM : this.lastBPM - bpm;
        if (diff > 1.5) {
            this.lastBPM = Math.round(bpm);
        }
        return this.lastBPM;
    }

    public void cycle() {
        this.outBPM.setModified(false);
        if (this.inClock.isModified()) {
            this.inClock.read();
            double curTime = super.getTime();
            int index = 4;
            for (double previousTime : this.times) {
                double distance = (curTime - previousTime) / (double)index;
                this.addDistance(distance);
                --index;
            }
            if (this.lastTime2 > 0.0) {
                double dMiss = (curTime - this.lastTime) / 2.0;
                this.addDistance(dMiss);
                double dDouble = curTime - this.lastTime2;
                this.addDistance(dDouble);
            }
            this.times.add(curTime);
            this.lastTime2 = this.lastTime;
            this.lastTime = curTime;
            if (this.times.size() > 4) {
                this.times.remove(0);
            }
            this.removeOldDistances();
            int historySize = this.distancesSorted.size();
            int medianSize = (int)((double)historySize * 0.2);
            if (medianSize > 0 && historySize > 0) {
                int minIndex = (historySize - medianSize) / 2;
                int maxIndex = minIndex + medianSize;
                double averageDistance = 0.0;
                int i = minIndex;
                while (i < maxIndex) {
                    averageDistance += this.distancesSorted.get(i).doubleValue();
                    ++i;
                }
                double bpm = 60.0 / (averageDistance /= (double)medianSize);
                bpm = this.makeLookSexy(bpm);
                System.out.println("BPM: " + bpm);
                ClockData clock = new ClockData(curTime, bpm / 60.0);
                this.outBPM.write(clock);
            }
        }
    }
}

