/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import org.corebounce.decklight.ports.PublicCloneable;
import org.corebounce.utils.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequenciesData
implements PublicCloneable<FrequenciesData> {
    public float[][] data;
    public int nbChannels;
    public int nbBins;

    public FrequenciesData(float[][] data) {
        this.data = data;
        this.nbChannels = data.length;
        this.nbBins = data[0].length;
    }

    public FrequenciesData(int nbChannels, int nbBins) {
        Log.debug("Creating Frequencies, channels={0}, {1} bins.", nbChannels, nbBins);
        this.data = new float[nbChannels][nbBins];
        this.nbChannels = nbChannels;
        this.nbBins = nbBins;
    }

    public int getNbFrames() {
        return (this.nbBins - 1) * 2;
    }

    @Override
    public FrequenciesData clone() {
        try {
            FrequenciesData result = (FrequenciesData)super.clone();
            result.data = new float[this.nbChannels][this.nbBins];
            int c = 0;
            while (c < this.nbChannels) {
                System.arraycopy(this.data[c], 0, result.data[c], 0, this.nbBins);
                ++c;
            }
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    @Override
    public void copyTo(FrequenciesData clone) {
        if (clone.data == null || clone.nbChannels != this.nbChannels || clone.nbBins != this.nbBins) {
            clone.nbChannels = this.nbChannels;
            clone.nbBins = this.nbBins;
            clone.data = new float[this.nbChannels][this.nbBins];
        }
        int c = 0;
        while (c < this.nbChannels) {
            System.arraycopy(this.data[c], 0, clone.data[c], 0, this.nbBins);
            ++c;
        }
    }
}

