/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.ports.PublicCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowInfo
implements PublicCloneable<WindowInfo> {
    private float[] window;
    private boolean windowModified;
    private PowerOf2 overlapping;
    private PowerOf2 zeroPadding;
    private float[][] windowCycle;

    public WindowInfo(float[] window, PowerOf2 overlapping) {
        this.window = window;
        this.windowModified = true;
        this.windowCycle = null;
        this.overlapping = overlapping;
        this.setZeroPadding(PowerOf2.p1);
    }

    public WindowInfo(WindowInfo other) {
        this.window = other.window;
        this.windowModified = other.windowModified;
        this.windowCycle = other.windowCycle;
        this.overlapping = other.overlapping;
        this.zeroPadding = other.zeroPadding;
    }

    public void copyFrom(WindowInfo other) {
        this.window = other.window;
        this.windowModified = other.windowModified;
        this.windowCycle = other.windowCycle;
        this.overlapping = other.overlapping;
        this.zeroPadding = other.zeroPadding;
    }

    public static WindowInfo noWindow(int length) {
        float[] shape = WindowFactory.getWindow(WindowType.Rectangular, length);
        WindowInfo result = new WindowInfo(shape, PowerOf2.p1);
        return result;
    }

    public void setWindow(float[] window) {
        this.window = window;
    }

    public float[] getWindow() {
        return this.window;
    }

    public int windowLength() {
        return this.window.length;
    }

    public void setWindowModified(boolean windowModified) {
        this.windowModified = windowModified;
    }

    public boolean isWindowModified() {
        return this.windowModified;
    }

    public void setOverlapping(PowerOf2 overlapping) {
        this.overlapping = overlapping;
    }

    public PowerOf2 getOverlapping() {
        return this.overlapping;
    }

    public void setWindowCycle(float[][] windowCycle) {
        this.windowCycle = windowCycle;
    }

    public float[][] getWindowCycle() {
        return this.windowCycle;
    }

    public int cycleLength() {
        if (this.windowCycle == null) {
            return 1;
        }
        return this.windowCycle.length;
    }

    public void setZeroPadding(PowerOf2 zeroPadding) {
        this.zeroPadding = zeroPadding;
    }

    public PowerOf2 getZeroPadding() {
        return this.zeroPadding;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WindowInfo) {
            WindowInfo other = (WindowInfo)obj;
            return this.overlapping.equals((Object)other.overlapping) && this.zeroPadding.equals((Object)other.zeroPadding) && this.eq(this.window, other.window);
        }
        return false;
    }

    private boolean eq(float[] a1, float[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a1.length) {
            if (a1[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.overlapping.hashCode() ^ this.zeroPadding.hashCode() ^ this.hashCode(this.window);
    }

    private int hashCode(float[] a) {
        int result = 1;
        float[] fArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            float element = fArray[n2];
            result = 31 * result + Float.floatToRawIntBits(element);
            ++n2;
        }
        return result;
    }

    @Override
    public WindowInfo clone() {
        try {
            WindowInfo result = (WindowInfo)super.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    @Override
    public void copyTo(WindowInfo clone) {
        clone.window = this.window;
        clone.windowModified = this.windowModified;
        clone.overlapping = this.overlapping;
        clone.zeroPadding = this.zeroPadding;
    }
}

