/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.channels;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.utils.Severity;

public class MergeChannels
extends Bouncelet {
    public InAudio inAudio0 = new InAudio("in0", "Input audio channel 0");
    public InAudio inAudio1 = new InAudio("in1", "Input audio channel 1");
    public InAudio inAudio2 = new InAudio("in2", "Input audio channel 2");
    public InAudio inAudio3 = new InAudio("in3", "Input audio channel 3");
    public InAudio inAudio4 = new InAudio("in4", "Input audio channel 4");
    public InAudio inAudio5 = new InAudio("in5", "Input audio channel 5");
    public InAudio inAudio6 = new InAudio("in6", "Input audio channel 6");
    public InAudio inAudio7 = new InAudio("in7", "Input audio channel 7");
    public InAudio inAudio8 = new InAudio("in8", "Input audio channel 8");
    public InAudio inAudio9 = new InAudio("in9", "Input audio channel 9");
    public OutAudio outAudio = new OutAudio("out", "Output multi-channel audio wave");
    public InAudio[] inAudios = new InAudio[]{this.inAudio0, this.inAudio1, this.inAudio2, this.inAudio3, this.inAudio4, this.inAudio5, this.inAudio6, this.inAudio7, this.inAudio8, this.inAudio9};
    private int lastNbChannels = 0;
    private int lastNbFrames = 0;
    private boolean hasWarned = false;

    public MergeChannels() {
        super("audio.convert.channels.mergeChannels", "Merge mono audio waves into a multi-channel audio wave");
        super.setSkillType(SkillType.ADVANCED);
        int i = 4;
        while (i < this.inAudios.length) {
            this.inAudios[i].setSkillType(SkillType.ADVANCED);
            ++i;
        }
    }

    protected void reset() {
        super.reset();
        this.hasWarned = false;
    }

    public void cycle() {
        int nbFrames = 0;
        int nbChannels = 0;
        boolean connected = true;
        int c = 0;
        while (c < this.inAudios.length) {
            if (!this.inAudios[c].isConnected()) {
                connected = false;
            }
            if (connected) {
                ++nbChannels;
                WaveData inWave = (WaveData)this.inAudios[c].peek();
                if (nbFrames == 0) {
                    nbFrames = inWave.nbFrames;
                } else if (nbFrames != inWave.nbFrames) {
                    this.log("Input channels have different block sizes", new Object[0]);
                }
                if (inWave.nbChannels != 1) {
                    this.log("Input {0} is not mono", this.inAudios[c].getName());
                }
            }
            ++c;
        }
        if (nbChannels == 0) {
            nbChannels = 2;
        }
        if (nbFrames == 0) {
            nbFrames = AudioConfig.blockSize();
        }
        if (this.lastNbChannels != nbChannels) {
            this.lastNbChannels = nbChannels;
            this.hasWarned = false;
        }
        if (this.lastNbFrames != nbFrames) {
            this.lastNbFrames = nbFrames;
            this.hasWarned = true;
        }
        WaveData firstWave = (WaveData)this.inAudios[0].peek();
        this.outAudio.prepare(nbChannels, nbFrames, firstWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < nbChannels) {
            int i;
            float[] in = ((WaveData)this.inAudios[chan].read()).data[0];
            float[] out = outWave.data[chan];
            if (in.length == nbFrames) {
                i = 0;
                while (i < nbFrames) {
                    out[i] = in[i];
                    ++i;
                }
            } else {
                i = 0;
                while (i < nbFrames) {
                    out[i] = 0.0f;
                    ++i;
                }
            }
            ++chan;
        }
    }

    private void log(String message, Object ... args) {
        if (!this.hasWarned) {
            super.log(GraphErrorType.IllegalArgument, Severity.Error, message, args);
            this.hasWarned = true;
        }
    }
}

