/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.channels;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.utils.Severity;

public class QuadToStereo
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input 4-channels audio wave");
    public OutAudio outAudio = new OutAudio("out", "Output stereo audio wave");

    public QuadToStereo() {
        super("audio.convert.channels.quad2stereo", "Convert 4-channels audio to stereo (prologic) audio");
        super.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        if (inWave.nbChannels != 4) {
            super.log(GraphErrorType.IllegalArgument, Severity.Error, "Number of channels not supported for input: {0}", inWave.nbChannels);
        }
        this.outAudio.prepare(2, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        float[] inLeft = inWave.data[0 % inWave.nbChannels];
        float[] inRight = inWave.data[1 % inWave.nbChannels];
        float[] inCenter = inWave.data[2 % inWave.nbChannels];
        float[] inSurround = inWave.data[3 % inWave.nbChannels];
        float[] outLeft = outWave.data[0];
        float[] outRight = outWave.data[1];
        int i = 0;
        while (i < inWave.nbFrames) {
            outLeft[i] = (inLeft[i] + inCenter[i] + inSurround[i]) / 2.0f;
            outRight[i] = (inRight[i] + inCenter[i] - inSurround[i]) / 2.0f;
            ++i;
        }
    }
}

