/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.channels;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.utils.Severity;

public class StereoToQuad
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input stereo audio wave");
    public OutAudio outAudio = new OutAudio("out", "Output 4-channels audio wave");

    public StereoToQuad() {
        super("audio.convert.channels.stereo2quad", "Convert stereo audio to 4-channels audio (left, right, center, surround)");
        super.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        if (inWave.nbChannels != 2) {
            super.log(GraphErrorType.IllegalArgument, Severity.Error, "Number of channels not supported for input: {0}", inWave.nbChannels);
        }
        this.outAudio.prepare(4, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        float[] inLeft = inWave.data[0];
        float[] inRight = inWave.data[1 % inWave.nbChannels];
        float[] outLeft = outWave.data[0];
        float[] outRight = outWave.data[1];
        float[] outCenter = outWave.data[2];
        float[] outSurround = outWave.data[3];
        int i = 0;
        while (i < inWave.nbFrames) {
            float left = inLeft[i];
            float right = inRight[i];
            outLeft[i] = left;
            outRight[i] = right;
            outCenter[i] = (left + right) / 2.0f;
            outSurround[i] = (left - right) / 2.0f;
            ++i;
        }
    }
}

