/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutFrequencies;
import org.corebounce.decklight.bridge.SkillType;

public class SpectrumToFrequencies
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public OutFrequencies outFreqs = new OutFrequencies("out", "Output frequencies");

    public SpectrumToFrequencies() {
        super("audio.convert.format.spectrum2frequencies", "Convert audio spectrum to frequencies");
        super.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        SpectrumData input = (SpectrumData)this.inSpectrum.read();
        this.outFreqs.prepare(input.nbChannels, input.nbBins);
        FrequenciesData output = (FrequenciesData)this.outFreqs.get();
        float correction = 1.0f / (float)input.nbChannels;
        int chan = 0;
        while (chan < input.nbChannels) {
            Cmplx[] in = input.data[chan];
            float[] out = output.data[chan];
            int i = 0;
            while (i < input.nbBins) {
                out[i] = in[i].mag() * correction;
                ++i;
            }
            ++chan;
        }
    }
}

