/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class Value2Wave
extends Bouncelet {
    public InDouble inValue = new InDouble("value", "Input value");
    public InPowerOf2 inBlockSize = new InPowerOf2(true, "blockSize", "Audio blocks size", PowerOf2.p64);
    public InInt inChannels = new InInt("channels", "Number of channels to generate", 2, 1, 10);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public Value2Wave() {
        super("audio.convert.format.value2wave", "Convert a value to a wave");
        super.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        int blockSize = ((PowerOf2)((Object)this.inBlockSize.read())).intValue();
        this.outAudio.prepare((Integer)this.inChannels.read(), blockSize, null);
        WaveData outWave = (WaveData)this.outAudio.get();
        double value = (Double)this.inValue.read();
        int chan = 0;
        while (chan < outWave.nbChannels) {
            float[] output = outWave.data[chan];
            int i = 0;
            while (i < output.length) {
                output[i] = (float)value;
                ++i;
            }
            ++chan;
        }
    }
}

