/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.convert.format.BlockSize;
import org.corebounce.decklight.bouncelets.audio.convert.format.advanced.SplitWindows;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaveToWindows
extends MacroBouncelet {
    private final BlockSize blockSize = new BlockSize(PowerOf2.p64, "shiftSize", "Overlapping shift");
    private final SplitWindows split = new SplitWindows(PowerOf2.p128);

    public WaveToWindows() {
        super("audio.convert.format.wave2windows", "Convert audio wave to audio windows");
        super.setSkillType(SkillType.EXPERT);
    }

    public InAudio getInAudio() {
        return this.blockSize.inAudio;
    }

    public OutAudio getOutAudio() {
        return this.split.outAudio;
    }

    public void setOverlap(PowerOf2 blockSize, PowerOf2 shiftSize, WindowType wType) {
        this.blockSize.inBlockSize.write(shiftSize);
        this.split.inWindowSize.write(blockSize);
        this.split.inWindowType.write(wType);
    }

    public Bouncelet[] getParts() {
        return new Bouncelet[]{this.blockSize, this.split};
    }

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.blockSize.outAudio, this.split.inAudio);
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return new InputPort[]{this.blockSize.inAudio, this.blockSize.inBlockSize, this.split.inWindowSize, this.split.inWindowType};
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.split.outAudio};
    }
}

