/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.advanced;

import org.corebounce.common.dsp.BooFFT;
import org.corebounce.common.dsp.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.WorkBuffers;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutFrequencies;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;

public class FrequenciesFFT
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InBoolean inFast = new InBoolean("fast", "Use fast approximation (RMS -32.8 dB) instead of exact computation", true);
    public OutFrequencies outFreqs = new OutFrequencies("out", "Output frequencies");
    private float[][] mergeBuffer;
    private int mergeOffset;
    private BooFFT fft;
    private Cmplx[] result;
    private boolean fast;

    public FrequenciesFFT() {
        super("audio.convert.format.advanced.powerFFT", "Mono Frequencies analyzer (with 50% overlapping and Hanning window)");
        super.setSkillType(SkillType.EXPERT);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        WaveData wave = (WaveData)this.inAudio.read();
        int windowSize = wave.nbFrames * 2;
        int nbBins = windowSize / 2 + 1;
        if (this.outFreqs.prepare(1, nbBins)) {
            this.mergeBuffer = new float[windowSize][wave.nbFrames * 2];
            this.mergeOffset = 0;
            this.fft = BooFFT.getInstance(windowSize / 2);
            this.result = WorkBuffers.getCmplxBuffer(nbBins);
        }
        this.fast = (Boolean)this.inFast.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void process() {
        wave = (WaveData)this.inAudio.read();
        windowSize = wave.nbFrames * 2;
        nbBins = windowSize / 2 + 1;
        spectrum = (FrequenciesData)this.outFreqs.get();
        values = spectrum.data[0];
        correction = 1.0f / (float)wave.nbChannels;
        chan = 0;
        while (chan < wave.nbChannels) {
            block10: {
                block13: {
                    block11: {
                        block12: {
                            in = wave.data[chan];
                            out = this.mergeBuffer[chan];
                            i = 0;
                            j = this.mergeOffset;
                            while (i < wave.nbFrames) {
                                out[j] = in[i];
                                ++i;
                                ++j;
                            }
                            var10_10 = this.result;
                            // MONITORENTER : this.result
                            this.fft.forwR2C(this.mergeBuffer[chan], this.result);
                            Windows.convolveHann(this.result);
                            if (!FrequenciesFFT.$assertionsDisabled && values.length != nbBins) {
                                throw new AssertionError();
                            }
                            if (chan != 0) break block11;
                            if (!this.fast) break block12;
                            i = 0;
                            if (true) ** GOTO lbl50
                        }
                        i = 0;
                        if (true) ** GOTO lbl55
                    }
                    if (!this.fast) break block13;
                    i = 0;
                    if (true) ** GOTO lbl61
                }
                i = 0;
                while (i < nbBins) {
                    v0 = i;
                    values[v0] = values[v0] + this.result[i].mag() * correction;
                    ++i;
                }
                break block10;
                do {
                    values[i] = this.result[i].magApprox() * correction;
                    ++i;
lbl50:
                    // 2 sources

                } while (i < nbBins);
                break block10;
                do {
                    values[i] = this.result[i].mag() * correction;
                    ++i;
lbl55:
                    // 2 sources

                } while (i < nbBins);
                break block10;
                do {
                    v2 = i;
                    values[v2] = values[v2] + this.result[i].magApprox() * correction;
                    ++i;
lbl61:
                    // 2 sources

                } while (i < nbBins);
            }
            // MONITOREXIT : var10_10
            ++chan;
        }
        this.mergeOffset = (this.mergeOffset + wave.nbFrames) % windowSize;
    }
}

