/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.advanced;

import org.corebounce.common.dsp.Windows;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InWindowType;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.utils.Log;
import org.corebounce.utils.Severity;

public class MergeWindows
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public InWindowType inPostWindow = new InWindowType("postWindow", "Post-processing correction window", WindowType.Hann);
    public OutAudio outAudio = new OutAudio("out", "Output Audio Wave");
    private float[][] mergeBuffer;
    private int mergeOffset;
    private int windowSize;
    private int windowMask;
    private float[] postWindow;
    private float[] energies;
    private float[][] inverseWindows;
    private int cycleIndex;
    private WindowInfo noWindowing;
    private int outputSize;
    private boolean isInvalid = false;
    private boolean isDirty;

    public MergeWindows() {
        super("audio.convert.format.advanced.mergewindows", "Merge overlapping windows");
        super.setSkillType(SkillType.EXPERT);
        this.inPostWindow.setSkillType(SkillType.EXPERT);
    }

    protected void reset() {
        super.reset();
        this.cycleIndex = 0;
        this.isInvalid = false;
        this.isDirty = true;
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        int shift;
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outputSize = shift = inWave.nbFrames / inWave.windowing.getOverlapping().intValue();
        boolean changes = this.outAudio.prepare(inWave.nbChannels, shift, this.noWindowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        if (changes || this.isDirty) {
            this.mergeBuffer = new float[outWave.nbChannels][inWave.nbFrames];
            this.mergeOffset = 0;
            this.windowSize = inWave.nbFrames;
            this.windowMask = this.windowSize - 1;
            assert ((this.windowSize & this.windowMask) == 0) : "windowSize must be a power of two";
            float[] window = WindowFactory.getWindow(WindowType.Rectangular, shift);
            this.noWindowing = new WindowInfo(window, PowerOf2.p1);
            this.isInvalid = false;
        }
        if (this.inPostWindow.isModified() || changes || this.isDirty) {
            this.postWindow = WindowFactory.getWindow((WindowType)((Object)this.inPostWindow.read()), this.windowSize);
            assert (this.postWindow.length == this.windowSize);
            this.rebuildInverseWindows(inWave);
        } else if (inWave.windowing.isWindowModified()) {
            this.rebuildInverseWindows(inWave);
        }
        if (inWave.windowing.isWindowModified() || this.isDirty) {
            this.cycleIndex = 0;
        }
        this.isDirty = false;
        outWave.windowing = this.noWindowing;
    }

    private void process() {
        int i;
        float[] buffer;
        float[] in;
        WaveData inWave = (WaveData)this.inAudio.read();
        int shift = inWave.nbFrames / inWave.windowing.getOverlapping().intValue();
        int overlapping = inWave.nbFrames - shift;
        WaveData outWave = (WaveData)this.outAudio.get();
        float correction = 1.0f;
        if (this.energies != null) {
            correction = Windows.getStdEnergy(this.postWindow.length) / this.energies[this.cycleIndex];
        }
        int chan = 0;
        while (chan < inWave.nbChannels) {
            in = inWave.data[chan];
            buffer = this.mergeBuffer[chan];
            int i2 = 0;
            while (i2 < overlapping) {
                int n = i2 + this.mergeOffset & this.windowMask;
                buffer[n] = buffer[n] + in[i2] * correction * this.postWindow[i2];
                ++i2;
            }
            ++chan;
        }
        this.mergeOffset = this.mergeOffset + overlapping & this.windowMask;
        chan = 0;
        while (chan < inWave.nbChannels) {
            in = inWave.data[chan];
            buffer = this.mergeBuffer[chan];
            int j = overlapping;
            i = 0;
            while (i < shift) {
                buffer[i + this.mergeOffset & this.windowMask] = in[j] * correction * this.postWindow[j];
                ++i;
                ++j;
            }
            ++chan;
        }
        assert (shift + overlapping == this.postWindow.length);
        this.mergeOffset = this.mergeOffset + shift & this.windowMask;
        float[] invWindow = this.inverseWindows[this.cycleIndex];
        assert (outWave.nbFrames == shift);
        int chan2 = 0;
        while (chan2 < inWave.nbChannels) {
            buffer = this.mergeBuffer[chan2];
            float[] out = outWave.data[chan2];
            i = 0;
            while (i < shift) {
                out[i] = buffer[i + this.mergeOffset & this.windowMask] * invWindow[i];
                ++i;
            }
            ++chan2;
        }
        this.mergeOffset = this.mergeOffset + shift & this.windowMask;
        this.cycleIndex = (this.cycleIndex + 1) % this.inverseWindows.length;
    }

    private void rebuildInverseWindows(WaveData inWave) {
        Log.debug("MergeWindows {0}: rebuilding inverse window", this);
        this.inverseWindows = new float[inWave.windowing.cycleLength()][];
        if (this.inverseWindows.length > 1) {
            this.energies = new float[this.inverseWindows.length];
            float[][] preWindows = inWave.windowing.getWindowCycle();
            int i = 0;
            while (i < this.inverseWindows.length) {
                this.energies[i] = Windows.getPostEnergy(preWindows[i], this.postWindow);
                ++i;
            }
        } else {
            this.energies = null;
        }
        int i = 0;
        while (i < this.inverseWindows.length) {
            this.inverseWindows[i] = this.buildInverseWindow(inWave, i, this.postWindow, this.outputSize);
            ++i;
        }
    }

    private float[] buildInverseWindow(WaveData inWave, int cycleIndex, float[] postWindow, int outputSize) {
        int windowSize = postWindow.length;
        float[] result = new float[outputSize];
        boolean success = false;
        success = inWave.windowing.getWindowCycle() == null || this.energies == null ? Windows.fillInverseWindow(inWave.windowing.getWindow(), postWindow, result, windowSize, outputSize) : Windows.fillInverseWindow(inWave.windowing.getWindowCycle(), cycleIndex, this.energies, postWindow, result, windowSize, outputSize);
        if (!success && !this.isInvalid) {
            super.log(GraphErrorType.IllegalArgument, Severity.Warning, "Failed to create inverse window", new Object[0]);
            this.isInvalid = true;
        }
        return result;
    }
}

