/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.advanced;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.InWindowType;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;

public class SplitWindows
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public InPowerOf2 inWindowSize = new InPowerOf2(true, "blockSize", "Window size", PowerOf2.p2048);
    public InWindowType inWindowType = new InWindowType("window", "Window type", WindowType.Hann);
    public OutAudio outAudio = new OutAudio("out", "Output Audio Wave");
    private float[][] circularBuffer;
    private int circularOffset;
    private WindowInfo windowing;
    private transient PowerOf2 overlapping;
    private transient int windowSize;
    private transient boolean isDirty;

    public SplitWindows() {
        super("audio.convert.format.advanced.splitwindows", "Split into overlapping windows");
        super.setSkillType(SkillType.EXPERT);
    }

    public SplitWindows(PowerOf2 windowSize) {
        this();
        this.inWindowSize = new InPowerOf2(true, "blockSize", "Window size", windowSize);
        this.inWindowType.setSkillType(SkillType.EXPERT);
    }

    protected void reset() {
        super.reset();
        this.isDirty = true;
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        PowerOf2 overlapping;
        WaveData srcWave = (WaveData)this.inAudio.read();
        this.windowSize = ((PowerOf2)((Object)this.inWindowSize.read())).intValue();
        int shift = srcWave.nbFrames;
        if (shift > this.windowSize) {
            this.windowSize = shift;
        }
        boolean newWindow = (overlapping = PowerOf2.fromInt(this.windowSize / shift)) != this.overlapping;
        this.overlapping = overlapping;
        WindowType windowType = (WindowType)((Object)this.inWindowType.read());
        boolean changes = this.outAudio.prepare(srcWave.nbChannels, this.windowSize, this.windowing);
        if (changes || this.isDirty || (newWindow |= this.inWindowType.isModified())) {
            this.circularBuffer = new float[srcWave.nbChannels][this.windowSize];
            this.circularOffset = 0;
            float[] window = WindowFactory.getWindow(windowType, this.windowSize);
            this.windowing = new WindowInfo(window, this.overlapping);
            this.isDirty = false;
        }
        this.windowing.setWindowModified(newWindow || srcWave.windowing.isWindowModified());
    }

    private void process() {
        WaveData srcWave = (WaveData)this.inAudio.read();
        int shift = srcWave.nbFrames;
        int chan = 0;
        while (chan < srcWave.nbChannels) {
            float[] in = srcWave.data[chan];
            float[] out = this.circularBuffer[chan];
            System.arraycopy(in, 0, out, this.circularOffset, shift);
            ++chan;
        }
        this.circularOffset = (this.circularOffset + shift) % this.windowSize;
        WaveData outWave = (WaveData)this.outAudio.get();
        outWave.windowing = this.windowing;
        float[] window = this.windowing.getWindow();
        int chan2 = 0;
        while (chan2 < srcWave.nbChannels) {
            float[] in = this.circularBuffer[chan2];
            float[] out = outWave.data[chan2];
            int i = 0;
            while (i < this.windowSize) {
                out[i] = in[(this.circularOffset + i) % this.windowSize] * window[i];
                ++i;
            }
            ++chan2;
        }
    }

    public int getLatency() {
        int shift = this.windowSize >>> this.overlapping.getLog2();
        return this.windowSize - shift;
    }
}

