/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.SharpInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.ports.InputPort;

public class FakeLayers
extends Bouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input Audio Spectrum");
    public InputPort<HqxMode> inMode = new InputPort<HqxMode>(HqxMode.class, "mode", "Mode", HqxMode.TRIPLE_HIGH);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output Audio Spectrum");
    private HqxMode mode;
    private SharpInfo sharpInfo;

    public FakeLayers() {
        super("audio.convert.format.asharp.fakelayers", "Convert spectrum to faked layered spectrum");
    }

    public void cycle() {
        if (this.inMode.isModified()) {
            this.mode = this.inMode.read();
            this.sharpInfo = this.mode.getInfo();
        }
        int nbLayers = this.sharpInfo.nbLayers;
        SpectrumData input = (SpectrumData)this.inAudio.read();
        this.outAudio.prepare(input.nbChannels * nbLayers, input.nbBins, nbLayers, this.mode, input.windowing);
        SpectrumData output = (SpectrumData)this.outAudio.get();
        float correction = 1.0f / (float)nbLayers;
        int dstChan = 0;
        while (dstChan < output.nbChannels) {
            int srcChan = dstChan / nbLayers;
            int i = 0;
            while (i < output.nbBins) {
                output.data[dstChan][i].set(input.data[srcChan][i].re * correction, input.data[srcChan][i].im * correction);
                ++i;
            }
            ++dstChan;
        }
    }
}

