/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

import org.corebounce.common.dsp.BooFFT;
import org.corebounce.common.dsp.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.KnifeInfo;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.time.EdgeExtractor;

public class Knife {
    private static final float MAX_JUMP = (float)AudioMath.dbToLevel(50.0);
    private final int nbChans;
    private final int blockSize;
    private final int shiftSize;
    private EdgeExtractor engine;
    private float[][] inBuffer;
    private float[][] srcBuffer;
    private int inIndex;
    private BooFFT fft;
    private Cmplx[][] inSpectrum;
    private Cmplx[][] srcSpectrum;
    private Cmplx[] shortx;
    private Cmplx[] longx;
    private float[] outBuffer;
    private float[][] outShort;
    private float[][] outLong;
    private int outIndex;
    private float correction;

    public Knife(int nbChans, KnifeInfo info) {
        this(nbChans, info, false);
    }

    public Knife(int nbChans, KnifeInfo info, boolean enableMonitorMode) {
        this.nbChans = nbChans;
        this.blockSize = info.blockSize;
        this.shiftSize = info.shiftSize;
        int nbBins = this.blockSize / 2 + 1;
        this.engine = new EdgeExtractor(nbChans, nbBins, info.minimizerLength, info.averagerLength, info.sensivityDb, info.attackTime, info.attackSpeedDb, info.minSpan, info.spread, info.hard, true, MAX_JUMP);
        this.inBuffer = new float[nbChans][this.blockSize];
        this.fft = BooFFT.getInstance(this.blockSize / 2);
        this.inSpectrum = Cmplx.newArray(nbChans, nbBins);
        if (enableMonitorMode) {
            this.srcBuffer = new float[nbChans][this.blockSize];
            this.srcSpectrum = Cmplx.newArray(nbChans, nbBins);
        }
        this.shortx = Cmplx.newArray(nbBins);
        this.longx = Cmplx.newArray(nbBins);
        this.outBuffer = new float[this.blockSize];
        this.outShort = new float[nbChans][this.blockSize];
        this.outLong = new float[nbChans][this.blockSize];
        this.correction = Windows.getHannCorrection(this.blockSize / this.shiftSize, 2);
    }

    public void processMonitored(float[][] source, float[][] input, float[][] outShort, float[][] outLong) {
        int offset = 0;
        while (offset < input[0].length) {
            this.processMonitored(source, input, outShort, outLong, offset);
            offset += this.shiftSize;
        }
    }

    public void process(float[][] source, float[][] input, float[][] outShort, float[][] outLong) {
        int offset = 0;
        while (offset < input[0].length) {
            this.process(source, input, outShort, outLong, offset);
            offset += this.shiftSize;
        }
    }

    private void processMonitored(float[][] source, float[][] input, float[][] resShort, float[][] resLong, int offset) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.forwardSTFT(source[chan], offset, this.srcBuffer[chan], this.inIndex, this.srcSpectrum[chan]);
            this.forwardSTFT(input[chan], offset, this.inBuffer[chan], this.inIndex, this.inSpectrum[chan]);
            ++chan;
        }
        this.engine.analyseMonitored(this.srcSpectrum, this.inSpectrum);
        chan = 0;
        while (chan < this.nbChans) {
            this.engine.processSplitted(this.inSpectrum[chan], chan, this.shortx, this.longx);
            this.overlapAdd(this.shortx, this.outShort[chan], this.outIndex, resShort[chan], offset);
            this.overlapAdd(this.longx, this.outLong[chan], this.outIndex, resLong[chan], offset);
            ++chan;
        }
        this.inIndex = (this.inIndex + this.shiftSize) % this.blockSize;
        this.outIndex = (this.outIndex + this.shiftSize) % this.blockSize;
    }

    private void process(float[][] source, float[][] input, float[][] resShort, float[][] resLong, int offset) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.forwardSTFT(source[chan], offset, this.inBuffer[chan], this.inIndex, this.inSpectrum[chan]);
            ++chan;
        }
        this.engine.analyseSplitted(this.inSpectrum);
        if (input != source) {
            chan = 0;
            while (chan < this.nbChans) {
                this.forwardSTFT(input[chan], offset, this.inBuffer[chan], this.inIndex, this.inSpectrum[chan]);
                ++chan;
            }
        }
        chan = 0;
        while (chan < this.nbChans) {
            this.engine.processSplitted(this.inSpectrum[chan], chan, this.shortx, this.longx);
            if (resShort != null) {
                this.overlapAdd(this.shortx, this.outShort[chan], this.outIndex, resShort[chan], offset);
            }
            if (resLong != null) {
                this.overlapAdd(this.longx, this.outLong[chan], this.outIndex, resLong[chan], offset);
            }
            ++chan;
        }
        this.inIndex = (this.inIndex + this.shiftSize) % this.blockSize;
        this.outIndex = (this.outIndex + this.shiftSize) % this.blockSize;
    }

    private void forwardSTFT(float[] input, int offset, float[] inBuffer, int inIndex, Cmplx[] result) {
        System.arraycopy(input, offset, inBuffer, inIndex, this.shiftSize);
        inIndex = (inIndex + this.shiftSize) % this.blockSize;
        this.fft.forwR2C(inBuffer, inIndex, this.blockSize, result);
        Windows.convolveHann(result);
    }

    private void overlapAdd(Cmplx[] spectrum, float[] olaBuffer, int olaIndex, float[] output, int offset) {
        Windows.convolveHann(spectrum);
        this.fft.backC2R(spectrum, this.outBuffer);
        int i = 0;
        while (i < this.blockSize - this.shiftSize) {
            int n = (i + olaIndex) % this.blockSize;
            olaBuffer[n] = olaBuffer[n] + this.outBuffer[i];
            ++i;
        }
        i = this.blockSize - this.shiftSize;
        while (i < this.blockSize) {
            olaBuffer[(i + olaIndex) % this.blockSize] = this.outBuffer[i];
            ++i;
        }
        i = 0;
        while (i < this.shiftSize) {
            output[i + offset] = olaBuffer[(i + olaIndex) % this.blockSize] * this.correction;
            ++i;
        }
    }

    public int getSampleLatency() {
        return this.blockSize - this.shiftSize;
    }
}

