/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

public class KnifeInfo {
    public final int blockSize;
    public final int shiftSize;
    public final int minimizerLength;
    public final int averagerLength;
    public final int minSpan;
    public final int spread;
    public final double sensivityDb;
    public final int attackTime;
    public final double attackSpeedDb;
    public final boolean hard;

    public KnifeInfo(int blockSize, int shiftSize, int minimizerLength, int averagerLength, int minSpan, int spread, double sensivityDb, int attackTime, double attackSpeedDb, boolean hard) {
        if (!KnifeInfo.isPowerOf2(blockSize) || !KnifeInfo.isPowerOf2(shiftSize) || shiftSize >= blockSize) {
            throw new IllegalArgumentException("Invalid STFT parameters");
        }
        if (minimizerLength <= 0 || averagerLength <= 0) {
            throw new IllegalArgumentException();
        }
        if (minSpan < 0 || spread < 0) {
            throw new IllegalArgumentException();
        }
        if (sensivityDb < 0.0 || attackTime < 0 || attackSpeedDb < 0.0) {
            throw new IllegalArgumentException();
        }
        this.blockSize = blockSize;
        this.shiftSize = shiftSize;
        this.minimizerLength = minimizerLength;
        this.averagerLength = averagerLength;
        this.minSpan = minSpan;
        this.spread = spread;
        this.sensivityDb = sensivityDb;
        this.attackTime = attackTime;
        this.attackSpeedDb = attackSpeedDb;
        this.hard = hard;
    }

    private static boolean isPowerOf2(int value) {
        return value >= 2 && (value & value - 1) == 0;
    }

    public String toString() {
        return "KnifeInfo[" + this.shiftSize + ":" + this.blockSize + "]";
    }
}

