/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

import java.util.Arrays;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.Cup;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.SharpInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;

public class SharpToWave
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private Cup[][] cups;
    private WindowInfo windowing;
    private int nbLayers;
    private HqxMode hqxMode;
    private int shiftSize;
    private int blockSize;

    public SharpToWave() {
        super("audio.convert.format.sharp2wave", "Sharp to wave");
        super.setSkillType(SkillType.ADVANCED);
    }

    protected void reset() {
        super.reset();
        this.cups = null;
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        SpectrumData spectrum = (SpectrumData)this.inSpectrum.peek();
        if (this.cups == null || this.cups.length != spectrum.audioChannels() || this.cups[0].length != spectrum.nbLayers || this.hqxMode != spectrum.hqxMode || this.shiftSize != spectrum.getShiftSize() || this.blockSize != spectrum.getNbFrames()) {
            this.hqxMode = spectrum.hqxMode;
            SharpInfo info = this.hqxMode.getInfo();
            this.windowing = WindowInfo.noWindow(info.shiftSize);
            this.nbLayers = info.nbLayers;
            this.shiftSize = info.shiftSize;
            this.blockSize = info.blockSize;
            this.cups = new Cup[spectrum.audioChannels()][info.nbLayers];
            int chan = 0;
            while (chan < this.cups.length) {
                int layer = 0;
                while (layer < info.nbLayers) {
                    this.cups[chan][layer] = new Cup(info.blockSize, info.shiftSize, info.layerInfo[layer].analysisShrink, info.layerInfo[layer].synthesisShrink, info.layerInfo[layer].enableEnergyCorrection);
                    ++layer;
                }
                ++chan;
            }
        }
        spectrum.nbLayers = this.nbLayers;
    }

    private void process() {
        SpectrumData spectrum = (SpectrumData)this.inSpectrum.read();
        this.outAudio.prepare(spectrum.nbChannels / this.nbLayers, this.shiftSize, this.windowing);
        WaveData wave = (WaveData)this.outAudio.get();
        int dstChan = 0;
        while (dstChan < wave.nbChannels) {
            float[] output = wave.data[dstChan];
            Arrays.fill(output, 0.0f);
            int layer = 0;
            while (layer < this.nbLayers) {
                int srcChan = dstChan * this.nbLayers + layer;
                Cmplx[] input = spectrum.data[srcChan];
                this.cups[dstChan][layer].processAdd(input, output);
                ++layer;
            }
            ++dstChan;
        }
    }
}

