/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

import org.corebounce.common.dsp.BooFFT;
import org.corebounce.common.dsp.Windows;
import org.corebounce.common.math.Cmplx;

public class Spoon {
    private final int blockSize;
    private final int shiftSize;
    private final int nbBins;
    private float[] inBuffer;
    private int inIndex;
    private float[] window;
    private float[] block;
    private BooFFT fft;

    public Spoon(int blockSize, int shiftSize, float analysisShrink, boolean energyCorrection) {
        this.blockSize = blockSize;
        this.shiftSize = shiftSize;
        this.nbBins = blockSize / 2 + 1;
        this.inBuffer = new float[blockSize];
        this.window = new float[blockSize];
        Windows.fillShrunkWindow(this.window, Windows.HannCoefs, analysisShrink, energyCorrection);
        this.block = new float[blockSize];
        this.fft = BooFFT.getInstance(blockSize / 2);
    }

    public void process(float[] input, Cmplx[] result) {
        if (input.length != this.shiftSize) {
            throw new IllegalArgumentException();
        }
        if (result.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(input, 0, this.inBuffer, this.inIndex, this.shiftSize);
        this.inIndex = (this.inIndex + this.shiftSize) % this.blockSize;
        int i = 0;
        while (i < this.blockSize) {
            this.block[i] = this.inBuffer[(i + this.inIndex) % this.blockSize] * this.window[i];
            ++i;
        }
        this.fft.forwR2C(this.block, result);
    }

    public int getSampleLatency() {
        return this.blockSize - this.shiftSize;
    }
}

