/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.convert.format.asharp;

import org.corebounce.common.dsp.Windows;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.Fork;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.SharpInfo;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.Spoon;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.ports.InputPort;

public class WaveToSharpBase
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InputPort<HqxMode> inMode = new InputPort<HqxMode>(HqxMode.class, "mode", "Mode", HqxMode.TRIPLE_HIGH);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");
    private int nbLayers;
    private int nbBins;
    private HqxMode hqxMode;
    private Fork fork;
    private Spoon[][] spoons;
    private WindowInfo windowing;

    public WaveToSharpBase() {
        super("audio.convert.format.wave2sharp", "Internal");
    }

    protected void reset() {
        super.reset();
        this.fork = null;
        this.spoons = null;
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        WaveData wave = (WaveData)this.inAudio.peek();
        if (this.fork == null || this.fork.getNbChans() != wave.nbChannels || this.inMode.isModified()) {
            this.hqxMode = this.inMode.read();
            SharpInfo info = this.hqxMode.getInfo();
            this.nbLayers = info.nbLayers;
            this.nbBins = info.blockSize / 2 + 1;
            float[] window = new float[info.blockSize];
            Windows.fillWindow(window, window.length, Windows.HannCoefs);
            this.windowing = new WindowInfo(window, PowerOf2.fromInt(info.blockSize / info.shiftSize));
            this.fork = new Fork(wave.nbChannels, info);
            this.spoons = new Spoon[wave.nbChannels][this.nbLayers];
            int chan = 0;
            while (chan < wave.nbChannels) {
                int layer = 0;
                while (layer < info.nbLayers) {
                    this.spoons[chan][layer] = new Spoon(info.blockSize, info.shiftSize, info.layerInfo[layer].analysisShrink, info.layerInfo[layer].enableEnergyCorrection);
                    ++layer;
                }
                ++chan;
            }
        }
    }

    private void process() {
        WaveData wave = (WaveData)this.inAudio.read();
        this.outSpectrum.prepare(wave.nbChannels * this.nbLayers, this.nbBins, this.nbLayers, this.hqxMode, this.windowing);
        SpectrumData spectrum = (SpectrumData)this.outSpectrum.get();
        spectrum.nbLayers = this.nbLayers;
        int dstChan = 0;
        this.fork.process(wave.data);
        int srcChan = 0;
        while (srcChan < wave.nbChannels) {
            Spoon[] spoon = this.spoons[srcChan];
            int s = 0;
            while (s < this.nbLayers) {
                spoon[s].process(this.fork.getOutput(s, srcChan), spectrum.data[dstChan++]);
                ++s;
            }
            ++srcChan;
        }
        this.windowing.setWindowModified(false);
    }

    public int getLatency() {
        return this.fork.getSampleLatency() + this.spoons[0][0].getSampleLatency();
    }
}

