/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect;

import java.util.Arrays;
import org.corebounce.common.dsp.BooFFT;
import org.corebounce.common.dsp.Windows;
import org.corebounce.common.math.Cmplx;

public class TestConvolve {
    private static final int START = 12;
    private static final int STOP = 16;

    public float[] test2() {
        float[] signal = new float[4096];
        this.fillSignal(signal);
        float[] result = new float[4096];
        BooFFT fft = BooFFT.getInstance(256);
        float[] window = new float[512];
        Cmplx[] spec = Cmplx.newArray(257);
        Cmplx[] filt = Cmplx.newArray(129);
        int i = 12;
        while (i <= 16) {
            filt[i].set(1.0f, 0.0f);
            ++i;
        }
        float[] bk = new float[256];
        BooFFT fft0 = BooFFT.getInstance(128);
        fft0.backC2R(filt, bk);
        float[] hann = new float[256];
        Windows.fillWindow(hann, 256, Windows.FlatTopCoefs);
        int i2 = 0;
        while (i2 < 256) {
            window[i2] = bk[(i2 + bk.length / 2) % bk.length] * 2.0f * hann[i2];
            ++i2;
        }
        Arrays.fill(window, 256, 512, 0.0f);
        Cmplx[] kernel = Cmplx.newArray(257);
        fft.forwR2C(window, kernel);
        int off = 1800;
        while (off < 3300) {
            System.arraycopy(signal, off, window, 0, 256);
            Arrays.fill(window, 256, 512, 0.0f);
            fft.forwR2C(window, spec);
            int i3 = 0;
            while (i3 < spec.length) {
                spec[i3].mul(kernel[i3]);
                ++i3;
            }
            fft.backC2R(spec, window);
            i3 = 0;
            while (i3 < 512) {
                int n = off + i3;
                result[n] = result[n] + window[i3];
                ++i3;
            }
            off += 256;
        }
        return result;
    }

    private void fillSignal(float[] signal) {
        signal[2048] = 1.0f;
    }

    public float[] test() {
        float[] signal = new float[4096];
        this.fillSignal(signal);
        float[] result = new float[4096];
        BooFFT fft = BooFFT.getInstance(128);
        float[] hann = new float[256];
        Windows.fillWindow(hann, 256, Windows.HannCoefs);
        float[] window = new float[256];
        Cmplx[] spec = Cmplx.newArray(129);
        int off = 1700;
        while (off < 3000) {
            System.arraycopy(signal, off, window, 0, 256);
            int i = 0;
            while (i < 256) {
                int n = i;
                window[n] = window[n] * (hann[i] * 2.0f);
                ++i;
            }
            fft.forwR2C(window, spec);
            i = 0;
            while (i < spec.length) {
                if (i < 12 || i > 16) {
                    spec[i].set(0.0f, 0.0f);
                }
                ++i;
            }
            fft.backC2R(spec, window);
            i = 0;
            while (i < 256) {
                int n = off + i;
                result[n] = result[n] + window[i] / 4.0f;
                ++i;
            }
            off += 64;
        }
        return result;
    }

    public static void main(String[] args) {
        float[] signal = new float[4096];
        new TestConvolve().fillSignal(signal);
        float[] r1 = new TestConvolve().test();
        float[] r2 = new TestConvolve().test2();
        int i = 1800;
        while (i < 3000) {
            float v0 = signal[i];
            float v1 = r1[i];
            float v2 = r2[i + 128];
            int j0 = 32 + (int)(v0 * 8.0f);
            int j1 = 32 + (int)(v1 * 1024.0f);
            int j2 = 32 + (int)(v2 * 1024.0f);
            int k = 0;
            while (k < 100) {
                if (k == j1 && k == j2) {
                    System.out.print("*");
                } else if (k == j2) {
                    System.out.print("+");
                } else if (k == j1) {
                    System.out.print("x");
                } else if (k == j0) {
                    System.out.print("S");
                } else {
                    System.out.print(" ");
                }
                if (k >= j1 && k >= j2 && k > j0) break;
                ++k;
            }
            System.out.println();
            ++i;
        }
    }
}

