/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect;

import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.FloatQueue;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.ports.InputPort;

public abstract class VariableRatePushBouncelet
extends Bouncelet {
    public OutAudio outAudio = new OutAudio("out", "Output Audio Wave"){

        @Override
        public boolean isManual() {
            return VariableRatePushBouncelet.this.outputQueue != null;
        }

        @Override
        protected WaveData fetch(InputPort<? super WaveData> target) {
            VariableRatePushBouncelet.this.sendOutputBlock();
            WaveData result = (WaveData)super.fetch(target);
            this.setModified(true);
            return result;
        }
    };
    private Fraction prevRatio = null;
    protected int nbFrames;
    protected int nbChans;
    protected float[][] outputBuffer;
    protected FloatQueue[] outputQueue;

    public VariableRatePushBouncelet(String name, String description) {
        super(name, description, true);
    }

    protected abstract InAudio getInAudio();

    protected abstract Fraction getRatio();

    protected abstract int getInterpolationGap();

    protected void reset() {
        super.reset();
        this.outputQueue = null;
        this.outputBuffer = null;
    }

    public final void cycle() {
        boolean changes = this.commonSetup();
        this.setup(changes);
        this.process();
    }

    private boolean commonSetup() {
        Fraction ratio = this.getRatio();
        WaveData input = (WaveData)this.getInAudio().peek();
        boolean changes = this.outAudio.prepare(input.nbChannels, input.nbFrames, input.windowing);
        if (changes || this.outputQueue == null) {
            int inputBufferSize = input.nbFrames + this.getInterpolationGap();
            int outputBufferSize = ratio.compareTo(1L) >= 0 ? (int)((double)input.nbFrames * ratio.doubleValue()) + this.getInterpolationGap() : (int)((double)input.nbFrames / ratio.doubleValue()) + this.getInterpolationGap();
            this.outputQueue = new FloatQueue[input.nbChannels];
            int i = 0;
            while (i < input.nbChannels) {
                this.outputQueue[i] = new FloatQueue(inputBufferSize, inputBufferSize + outputBufferSize);
                ++i;
            }
            this.outputBuffer = new float[input.nbChannels][outputBufferSize];
            this.nbFrames = input.nbFrames;
            this.nbChans = input.nbChannels;
            changes = true;
        }
        if (this.prevRatio != ratio) {
            changes = true;
        }
        this.prevRatio = ratio;
        return changes;
    }

    protected abstract void setup(boolean var1);

    protected abstract void process();

    private void sendOutputBlock() {
        WaveData output = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < output.nbChannels) {
            this.outputQueue[chan].popArray(output.data[chan]);
            ++chan;
        }
        this.outAudio.setModified(true);
    }

    public Fraction timeSkew() {
        return this.getRatio();
    }
}

