/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.base;

import java.util.Arrays;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.Buffer;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.base.GainEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Severity;

public class AutoGain
extends Bouncelet {
    private static final double MAX2AVG = 0.5;
    private static final int TROUBLESHOOT_LOGTIME = 2000;
    private static final int MAX_PEAKS_PER_SECOND = 20;
    private static final int PEAKS_DECAY_PER_SECOND = 5;
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inAttackSpeed = new InDouble("attack", "Attack speed [s/6dB]", 0.01, 0.001, 100.0);
    public InDouble inSustainTime = new InDouble("sustain", "Sustain time [s]", 2.0, 0.001, 10.0);
    public InDouble inDecaySpeed = new InDouble("decay", "Decay speed [s/6dB]", 1.0, 0.001, 100.0);
    public InDouble inTarget = new InDouble("target", "Target level [dB]", -3.0, -100.0, 20.0);
    public InDouble inThreshold = new InDouble("threshold", "Minimum amplified level [db]", -40.0, -100.0, 0.0);
    public InDouble inAccuracy = new InDouble("accuracy", "Maximum offset [dB]", 1.0, 0.0, 20.0);
    public InDouble inSmoothDelay = new InDouble("smooth", "Smooth delay [s]", 0.05, 0.001, 10.0);
    public InDouble inLatency = new InDouble("latency", "Latency [s]", 0.0, 0.0, 5.0);
    public InBoolean inTroubleshoot = new InBoolean("troubleshoot", "Enable console troubleshooting", true);
    public InBoolean inLockChannels = new InBoolean("lockChannels", "Apply same correction to all channels", true);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private GainEngine[] gainEngines;
    private Buffer[] delayBuffers;
    private float[] mixed;
    private long lastLowTime;
    private long lastHighTime;
    private double nbPeaks;
    private boolean low = false;
    private boolean high = false;

    public AutoGain() {
        super("audio.effect.base.autogain", "Adjust the gain automatically");
        this.setSkillType(SkillType.SIMPLIFIED);
        this.inAttackSpeed.setScaleType(ScaleType.LOG2);
        this.inSustainTime.setScaleType(ScaleType.LOG2);
        this.inDecaySpeed.setScaleType(ScaleType.LOG2);
        this.inSmoothDelay.setScaleType(ScaleType.LOG2);
        this.inTarget.setScaleType(ScaleType.CUBEROOT);
        this.inTarget.setSkillType(SkillType.NORMAL);
        this.inTroubleshoot.setSkillType(SkillType.NORMAL);
        this.inAttackSpeed.setSkillType(SkillType.ADVANCED);
        this.inSustainTime.setSkillType(SkillType.ADVANCED);
        this.inDecaySpeed.setSkillType(SkillType.ADVANCED);
        this.inThreshold.setSkillType(SkillType.ADVANCED);
        this.inAccuracy.setSkillType(SkillType.ADVANCED);
        this.inSmoothDelay.setSkillType(SkillType.ADVANCED);
        this.inLatency.setSkillType(SkillType.ADVANCED);
    }

    protected void reset() {
        super.reset();
        this.lastLowTime = System.currentTimeMillis();
        this.lastHighTime = System.currentTimeMillis();
        this.nbPeaks = 0.0;
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        WaveData wave = (WaveData)this.inAudio.read();
        boolean bufferChanges = this.inLatency.isModified() || this.inSmoothDelay.isModified();
        double waveDuration = wave.getRealDuration();
        double sampleDuration = waveDuration / (double)wave.nbFrames;
        double smoothDelay = (Double)this.inSmoothDelay.read();
        int historySize = (int)(smoothDelay / sampleDuration + 0.5);
        if (historySize < 1) {
            historySize = 1;
        }
        double attackSpeed = AudioMath.dbToLevel(6.0 * sampleDuration / (Double)this.inAttackSpeed.read());
        double sustainTime = (Double)this.inSustainTime.read();
        int sustainSpeed = (int)(sustainTime / sampleDuration + 0.5);
        if (sustainSpeed < 1) {
            sustainSpeed = 1;
        }
        double decaySpeed = 1.0 / AudioMath.dbToLevel(6.0 * sampleDuration / (Double)this.inDecaySpeed.read());
        double latency = (Double)this.inLatency.read();
        int latencySize = (int)(latency / sampleDuration + 0.5);
        double threshold = AudioMath.dbToLevel((Double)this.inThreshold.read()) * 0.5;
        if (this.gainEngines == null || bufferChanges || this.gainEngines.length != wave.nbChannels) {
            this.gainEngines = new GainEngine[wave.nbChannels];
            this.delayBuffers = new Buffer[wave.nbChannels];
            int i = 0;
            while (i < wave.nbChannels) {
                this.gainEngines[i] = new GainEngine(historySize, sustainSpeed, attackSpeed, decaySpeed, threshold);
                this.delayBuffers[i] = new Buffer(latencySize);
                ++i;
            }
            this.mixed = new float[wave.nbFrames];
        } else {
            int i = 0;
            while (i < wave.nbChannels) {
                this.gainEngines[i].setAttackSpeed(attackSpeed);
                this.gainEngines[i].setSustainSpeed(sustainSpeed);
                this.gainEngines[i].setDecaySpeed(decaySpeed);
                this.gainEngines[i].setJumpLevel(threshold);
                ++i;
            }
        }
    }

    private void process() {
        float[] input;
        int chan;
        double targetUpper = AudioMath.dbToLevel((Double)this.inTarget.read()) * 0.5;
        double accuracy = AudioMath.dbToLevel((Double)this.inAccuracy.read());
        double targetLower = targetUpper / accuracy;
        double thresholdLevel = AudioMath.dbToLevel((Double)this.inThreshold.read()) * 0.5;
        boolean isTroubleshooting = (Boolean)this.inTroubleshoot.read();
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        boolean lockChannels = (Boolean)this.inLockChannels.read();
        if (lockChannels) {
            Arrays.fill(this.mixed, 0.0f);
            chan = 0;
            while (chan < inWave.nbChannels) {
                input = inWave.data[chan];
                int i = 0;
                while (i < input.length) {
                    if (Math.abs(input[i]) > this.mixed[i]) {
                        this.mixed[i] = Math.abs(input[i]);
                    }
                    ++i;
                }
                ++chan;
            }
            chan = 0;
            while (chan < inWave.nbChannels) {
                this.gainEngines[chan].process(this.mixed);
                ++chan;
            }
        } else {
            chan = 0;
            while (chan < inWave.nbChannels) {
                input = inWave.data[chan];
                this.gainEngines[chan].process(input);
                ++chan;
            }
        }
        chan = 0;
        while (chan < inWave.nbChannels) {
            input = inWave.data[chan];
            float[] output = outWave.data[chan];
            if (isTroubleshooting) {
                int i = 0;
                while (i < input.length) {
                    if (input[i] <= -1.0f || input[i] >= 1.0f) {
                        this.nbPeaks += 1.0;
                    }
                    ++i;
                }
                if (this.nbPeaks > 20.0) {
                    this.high = true;
                    long now = System.currentTimeMillis();
                    if (now > this.lastHighTime + 2000L) {
                        super.log(GraphErrorType.DeviceError, Severity.Warning, "Warning: input level seems too high", new Object[0]);
                        this.lastHighTime = now;
                    }
                    this.nbPeaks = 0.0;
                } else {
                    double duration = inWave.getRealDuration();
                    this.nbPeaks -= 5.0 * duration;
                    if (this.nbPeaks < 0.0) {
                        this.nbPeaks = 0.0;
                    }
                }
            }
            double gain = this.gainEngines[chan].getGain();
            this.low = false;
            if (gain < thresholdLevel) {
                long now;
                this.low = true;
                if (isTroubleshooting && (now = System.currentTimeMillis()) > this.lastLowTime + 2000L) {
                    this.lastLowTime = now;
                    super.log(GraphErrorType.DeviceError, Severity.Warning, "Warning: input level is too low ({0}dB)", AudioMath.levelToDb(gain));
                }
                gain = thresholdLevel;
            } else if (isTroubleshooting) {
                this.lastLowTime = System.currentTimeMillis();
            }
            float correction = 1.0f;
            if (gain < targetLower) {
                correction = (float)(targetLower / gain);
            } else if (gain > targetUpper) {
                correction = (float)(targetUpper / gain);
            }
            int i = 0;
            while (i < input.length) {
                output[i] = input[i] * correction;
                ++i;
            }
            ++chan;
        }
    }

    public int getSourceLevel() {
        if (this.high) {
            this.high = false;
            return 1;
        }
        if (this.low) {
            return -1;
        }
        return 0;
    }
}

