/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.base;

import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.effect.base.DCBlockEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DCBlock
extends AudioStateWaveBouncelet<DCBlockEngine> {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inPole = new InDouble("pole", "Log(1.0 - Integrator pole)", -4.0, -8.0, 0.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public DCBlock() {
        super("audio.effect.base.dcblock", "Remove DC component", true);
        this.inPole.setScaleType(ScaleType.LINEAR);
        this.inPole.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public boolean checkForChanges() {
        return this.inPole.isModified();
    }

    protected DCBlockEngine[] createStates(int nbChans) {
        double pole = 1.0 - Math.pow(10.0, (Double)this.inPole.read());
        DCBlockEngine[] result = new DCBlockEngine[nbChans];
        int i = 0;
        while (i < result.length) {
            result[i] = new DCBlockEngine(pole);
            ++i;
        }
        return result;
    }

    @Override
    public void process(DCBlockEngine state, float[] input, float[] output) {
        state.process(input, output);
    }
}

