/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.base;

import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Gain
extends AudioMonoWaveBouncelet {
    public InAudio inAudio = new InAudio("in", "Input Channel");
    public InDouble inGain = new InDouble("gain", "Gain [dB]", 1.0, -100.0, 20.0);
    public InDouble inDCBias = new InDouble("dc", "DC bias", 0.0, -1.0, 1.0);
    public OutAudio outAudio = new OutAudio("out", "Output Channel");

    public Gain() {
        super("audio.effect.base.gain", "Gain", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inGain.setSkillType(SkillType.SIMPLIFIED);
        this.inDCBias.setSkillType(SkillType.ADVANCED);
    }

    public void init() {
    }

    public void dispose() {
    }

    public void process(float[] input, float[] output) {
        double gain = AudioMath.dbToLevel((Double)this.inGain.read());
        double dc = (Double)this.inDCBias.read();
        assert (input.length == output.length);
        int i = 0;
        while (i < input.length) {
            output[i] = input[i] * (float)gain + (float)dc;
            ++i;
        }
    }

    public void cycleInPlace() {
        if (this.inAudio.isModified() || this.inGain.isModified()) {
            double gain = (Double)this.inGain.read();
            WaveData wave = (WaveData)this.inAudio.read();
            int chan = 0;
            while (chan < wave.nbChannels) {
                float[] data = wave.data[chan];
                int i = 0;
                while (i < data.length) {
                    int n = i++;
                    data[n] = (float)((double)data[n] * gain);
                }
                ++chan;
            }
            super.copyInPlace(this.inAudio, this.outAudio);
        }
    }

    public void cycleOutOfPlace() {
        if (this.inAudio.isModified() || this.inGain.isModified()) {
            double gain = (Double)this.inGain.read();
            WaveData inputWave = (WaveData)this.inAudio.read();
            this.outAudio.prepare(inputWave.nbChannels, inputWave.nbFrames, inputWave.windowing);
            WaveData outputWave = (WaveData)this.outAudio.get();
            int chan = 0;
            while (chan < inputWave.nbChannels) {
                float[] inputData = inputWave.data[chan];
                float[] outputData = outputWave.data[chan];
                assert (inputData.length == outputData.length);
                int i = 0;
                while (i < inputData.length) {
                    outputData[i] = inputData[i] * (float)gain;
                    ++i;
                }
                ++chan;
            }
        }
    }
}

