/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.amplitude;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class AmplitudeSplitter
extends AudioExtractSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inAmplitude = new InDouble("amp", "Split amplitude [dB]", -30.0, -100.0, 20.0);
    public OutSpectrum outLoud = new OutSpectrum("loud", "Loud frequencies");
    public OutSpectrum outSoft = new OutSpectrum("soft", "Soft frequencies");
    private double powerAmp;

    public AmplitudeSplitter() {
        super("audio.effect.spectrum.amplitude.ampsplit", "Split soft and loud frequencies");
        super.setSkillType(SkillType.ADVANCED);
        this.inAmplitude.setSkillType(SkillType.SIMPLIFIED);
    }

    protected OutSpectrum getOutput1() {
        return this.outLoud;
    }

    protected OutSpectrum getOutput2() {
        return this.outSoft;
    }

    public void setup() {
        if (this.inAmplitude.isModified()) {
            this.powerAmp = AudioMath.dbToPowerLevel((Double)this.inAmplitude.read());
        }
    }

    public void process(int chan, Cmplx[] input, Cmplx[] loud, Cmplx[] soft) {
        int i = 0;
        while (i < input.length) {
            Cmplx bin = input[i];
            if ((double)bin.powerMag() > this.powerAmp) {
                loud[i].set(bin);
                soft[i].set(0.0f, 0.0f);
            } else {
                loud[i].set(0.0f, 0.0f);
                soft[i].set(bin);
            }
            ++i;
        }
    }
}

