/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.amplitude;

import java.util.Arrays;
import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class SinNoise
extends AudioExtractSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InInt inBands = new InInt("bands", "Number of bands", 10, 1, 50);
    public InInt inOverlap = new InInt("bandOverlap", "Bands overlapping", 2, 1, 5);
    public InDouble inRank = new InDouble("rank", "Gate rank", 0.5, 0.0, 1.0);
    public InDouble inThreshold = new InDouble("threshold", "Sinusoids threshold [dB]", 10.0, 0.0, 60.0);
    public InInt inMinSpan = new InInt("minspan", "Minimum bins for a band", 5, 1, 20);
    public InDouble inReject = new InDouble("reject", "Level of bins to ignore [dB]", -40.0, -100.0, -10.0);
    public InDouble inLower = new InDouble("lower", "Lower frequency below which everything is considered melody", 150.0, 16.0, AudioConfig.MAX_FREQUENCY);
    public InDouble inUpper = new InDouble("upper", "Upper frequency above which everything is considered noise", 8000.0, 16.0, AudioConfig.MAX_FREQUENCY);
    public OutSpectrum outMelody = new OutSpectrum("sin", "Sinusoids");
    public OutSpectrum outNoise = new OutSpectrum("noise", "Noise");
    private int[] bounds;
    private float[] levels;
    private float[] bandLevels;
    private BitSet sinusMap;
    private Cmplx[][] source;
    private int nbLayers;

    public SinNoise() {
        super("audio.effect.spectrum.amplitude.sin-noise", "Split sinusoids and noise");
        super.setSkillType(SkillType.ADVANCED);
        this.inBands.setSkillType(SkillType.ADVANCED);
        this.inOverlap.setSkillType(SkillType.ADVANCED);
        this.inThreshold.setSkillType(SkillType.ADVANCED);
        this.inMinSpan.setSkillType(SkillType.ADVANCED);
        this.inLower.setScaleType(ScaleType.LOG2);
        this.inUpper.setScaleType(ScaleType.LOG2);
    }

    protected OutSpectrum getOutput1() {
        return this.outNoise;
    }

    protected OutSpectrum getOutput2() {
        return this.outMelody;
    }

    protected void setup() {
        SpectrumData data = (SpectrumData)this.inAudio.peek();
        boolean changes = false;
        if (this.levels == null || this.levels.length != data.nbBins) {
            this.levels = new float[data.nbBins];
            this.bandLevels = new float[data.nbBins];
            this.sinusMap = new BitSet(data.nbBins);
            changes = true;
        }
        if (changes || this.inBands.isModified() || this.inOverlap.isModified() || this.inMinSpan.isModified()) {
            int nbBins = data.nbBins;
            int nbBands = (Integer)this.inBands.read();
            int overlap = (Integer)this.inOverlap.read();
            int minSpan = (Integer)this.inMinSpan.read();
            int nbBounds = nbBands + overlap - 1;
            this.bounds = new int[nbBounds];
            int prevBin = 0;
            int i = 0;
            while (i < nbBounds) {
                int bin = (int)(Math.exp(Math.log(nbBins) * (double)(i + 1) / (double)nbBounds) + 0.5);
                if (bin < prevBin + minSpan) {
                    bin = prevBin + minSpan;
                }
                this.bounds[i] = bin;
                prevBin = bin;
                ++i;
            }
        }
        if (this.source == null || this.source.length != data.audioChannels() || this.source[0].length != data.nbBins) {
            this.source = Cmplx.newArray(data.audioChannels(), data.nbBins);
            this.nbLayers = data.nbLayers;
        }
        data.fillSumByLayer(this.source);
    }

    public void process(int chan, Cmplx[] input, Cmplx[] outNoise, Cmplx[] outMelody) {
        Cmplx[] source = this.source[chan / this.nbLayers];
        int nbBands = (Integer)this.inBands.read();
        int overlap = (Integer)this.inOverlap.read();
        double rank = (Double)this.inRank.read();
        double sinThreshold = (Double)this.inThreshold.read();
        double rejectThreshold = (Double)this.inReject.read();
        int fftSize = (input.length - 1) * 2;
        int lowerBound = (int)((Double)this.inLower.read() * (double)fftSize / (double)AudioConfig.getSampleRate() + 0.5);
        int upperBound = (int)((Double)this.inUpper.read() * (double)fftSize / (double)AudioConfig.getSampleRate() + 0.5);
        this.sinusMap.clear();
        int i = 0;
        while (i < source.length) {
            this.levels[i] = source[i].powerMag();
            ++i;
        }
        int band = 0;
        while (band < nbBands) {
            int lower = band == 0 ? 0 : this.bounds[band - 1];
            int upper = this.bounds[band + overlap - 1];
            float maxLevel = 0.0f;
            int i2 = lower;
            while (i2 < upper) {
                if (this.levels[i2] > maxLevel) {
                    maxLevel = this.levels[i2];
                }
                ++i2;
            }
            float rejectLevel = maxLevel * (float)AudioMath.dbToPowerLevel(rejectThreshold);
            int count = 0;
            int i3 = lower;
            while (i3 < upper) {
                if (this.levels[i3] >= rejectLevel) {
                    this.bandLevels[count++] = this.levels[i3];
                }
                ++i3;
            }
            assert (count > 0);
            Arrays.sort(this.bandLevels, 0, count);
            int pivotIndex = (int)(rank * (double)(count - 1) + 0.5);
            float pivotLevel = this.bandLevels[pivotIndex];
            pivotLevel = (float)((double)pivotLevel * AudioMath.dbToPowerLevel(sinThreshold));
            int i4 = lower;
            while (i4 < upper) {
                if (i4 < lowerBound) {
                    this.sinusMap.set(i4);
                } else if (i4 < upperBound && this.levels[i4] >= pivotLevel) {
                    this.sinusMap.set(i4);
                }
                ++i4;
            }
            ++band;
        }
        i = 0;
        while (i < input.length) {
            if (this.sinusMap.get(i)) {
                outNoise[i].clear();
                outMelody[i].set(input[i]);
            } else {
                outNoise[i].set(input[i]);
                outMelody[i].clear();
            }
            ++i;
        }
    }
}

