/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.amplitude;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Turbo
extends AudioStateSpectrumBouncelet<double[]> {
    private static final double BOOST_CORRECTION = 7500.0;
    private static final double BUFF_CORRECTION = 4.0;
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inBoost = new InDouble("boost", "Boost amount", 5.0, 0.0, 25.0);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");
    private int nbBins = 0;
    private double correction;

    public Turbo() {
        super("audio.effect.spectrum.amplitude.turbo", "Boost rhythmics");
        super.setSkillType(SkillType.ADVANCED);
        this.inBoost.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public boolean checkForChanges() {
        SpectrumData spectrum = (SpectrumData)this.inAudio.peek();
        this.correction = spectrum.getRealDuration() * 7500.0;
        return spectrum.nbBins != this.nbBins;
    }

    protected double[][] createStates(int nbChans) {
        SpectrumData spectrum = (SpectrumData)this.inAudio.peek();
        this.nbBins = spectrum.nbBins;
        return new double[nbChans][this.nbBins];
    }

    @Override
    public void process(double[] state, int chan, Cmplx[] input, Cmplx[] output) {
        double boostFactor = (Double)this.inBoost.read();
        double adjustFactor = 1.0 / (1.0 + boostFactor / 4.0);
        int i = 0;
        while (i < input.length) {
            double norm = input[i].magApprox();
            double increase = (norm - state[i]) * this.correction;
            if (increase < 0.0) {
                increase = 0.0;
            }
            double newNorm = norm * (1.0 + increase * boostFactor) * adjustFactor;
            double ratio = norm == 0.0 ? 1.0 : newNorm / norm;
            output[i].set(input[i]);
            output[i].mul((float)ratio);
            state[i] = norm;
            ++i;
        }
    }
}

