/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Equalizer2
extends AudioMonoSpectrumBouncelet {
    private static final double[] frequencies = new double[]{86.0, 172.0, 345.0, 689.0, 1378.0, 2756.0, 5512.0, 8764.0, 13935.0};
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public InDouble inBand0 = new InDouble("band0", "[0-43 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand1 = new InDouble("band1", "[43-86 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand2 = new InDouble("band2", "[86-172 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand3 = new InDouble("band3", "[172-345 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand4 = new InDouble("band4", "[345-689 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand5 = new InDouble("band5", "[689-1378 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand6 = new InDouble("band6", "[1378-2756 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand7 = new InDouble("band7", "[2756-5512 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand8 = new InDouble("band8", "[5512-11025 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand9 = new InDouble("band9", "[11025-22050 Hz]", 0.0, -100.0, 20.0);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");
    private InDouble[] inBands = new InDouble[]{this.inBand0, this.inBand1, this.inBand2, this.inBand3, this.inBand4, this.inBand5, this.inBand6, this.inBand7, this.inBand8, this.inBand9};

    public Equalizer2() {
        super("audio.effect.spectrum.filter.equalizer2", "10 bands spectrum equalizer (linear phase)", true);
        super.setSkillType(SkillType.ADVANCED);
        InDouble[] inDoubleArray = this.inBands;
        int n = this.inBands.length;
        int n2 = 0;
        while (n2 < n) {
            InDouble inBand = inDoubleArray[n2];
            inBand.setSkillType(SkillType.SIMPLIFIED);
            inBand.setScaleType(ScaleType.CUBEROOT);
            ++n2;
        }
    }

    public void process(Cmplx[] input, Cmplx[] output) {
        double binSpace = (double)AudioConfig.getSampleRate() / (double)((input.length - 1) * 2);
        int startBin = 0;
        int stopBin = 0;
        int i = 0;
        while (i < 10) {
            startBin = stopBin;
            stopBin = i == 9 ? input.length : (int)(frequencies[i] / binSpace + 0.5);
            float gain = (float)AudioMath.dbToLevel((Double)this.inBands[i].read());
            int b = startBin;
            while (b < stopBin) {
                output[b].set(input[b].re * gain, input[b].im * gain);
                ++b;
            }
            ++i;
        }
    }
}

