/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter.FirEqualizerEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirEqualizerBase
extends AudioStateWaveBouncelet<FirEqualizerEngine> {
    static final PowerOf2 LENGTH = PowerOf2.p1024;
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inBand0 = new InDouble("band0", "[0-43 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand1 = new InDouble("band1", "[43-86 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand2 = new InDouble("band2", "[86-172 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand3 = new InDouble("band3", "[172-345 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand4 = new InDouble("band4", "[345-689 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand5 = new InDouble("band5", "[689-1378 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand6 = new InDouble("band6", "[1378-2756 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand7 = new InDouble("band7", "[2756-5512 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand8 = new InDouble("band8", "[5512-11025 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand9 = new InDouble("band9", "[11025-22050 Hz]", 0.0, -100.0, 20.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private InDouble[] inBands = new InDouble[]{this.inBand0, this.inBand1, this.inBand2, this.inBand3, this.inBand4, this.inBand5, this.inBand6, this.inBand7, this.inBand8, this.inBand9};
    private final float[] levels = new float[this.inBands.length];

    public FirEqualizerBase() {
        super("audio.effect.fourier.filter.fir-equalizer-base", "(Internal)");
        super.setSkillType(SkillType.SIMPLIFIED);
        InDouble[] inDoubleArray = this.inBands;
        int n = this.inBands.length;
        int n2 = 0;
        while (n2 < n) {
            InDouble inBand = inDoubleArray[n2];
            inBand.setSkillType(SkillType.SIMPLIFIED);
            inBand.setScaleType(ScaleType.CUBEROOT);
            ++n2;
        }
    }

    @Override
    public boolean checkForChanges() {
        return false;
    }

    protected FirEqualizerEngine[] createStates(int nbChans) {
        FirEqualizerEngine[] result = new FirEqualizerEngine[nbChans];
        int i = 0;
        while (i < nbChans) {
            result[i] = new FirEqualizerEngine(LENGTH.intValue());
            ++i;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        boolean modified = false;
        InDouble[] inDoubleArray = this.inBands;
        int n = this.inBands.length;
        int n2 = 0;
        while (n2 < n) {
            InDouble inBand = inDoubleArray[n2];
            if (inBand.isModified()) {
                modified = true;
                break;
            }
            ++n2;
        }
        if (modified) {
            int i = 0;
            while (i < this.inBands.length) {
                this.levels[i] = (float)AudioMath.dbToLevel((Double)this.inBands[i].read());
                ++i;
            }
        }
        super.setup(changes);
    }

    @Override
    public int getLatency() {
        int length = LENGTH.intValue();
        return length * 3 / 2;
    }

    @Override
    public void process(FirEqualizerEngine state, float[] input, float[] output) {
        state.setLevels(this.levels);
        state.process(input, output);
    }
}

