/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.convert.format.BlockSize;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter.HilbertBase;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hilbert
extends MacroBouncelet {
    private final BlockSize blockSizeIn = new BlockSize();
    private final HilbertBase hilbert = new HilbertBase();
    private final BlockSize blockSizeOut1 = new BlockSize();
    private final BlockSize blockSizeOut2 = new BlockSize();

    public Hilbert() {
        super("audio.effect.fourier.filter.hilbert", "Hilbert Transform using FIR filter");
        this.blockSizeOut1.setOutBlahblah(this.hilbert.outAudio1.getName(), this.hilbert.outAudio1.getDescription());
        this.blockSizeOut2.setOutBlahblah(this.hilbert.outAudio2.getName(), this.hilbert.outAudio2.getDescription());
        super.setSkillType(SkillType.EXPERT);
    }

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.blockSizeIn.outAudio, this.hilbert.inAudio);
        connector.connect(this.hilbert.outAudio1, this.blockSizeOut1.inAudio);
        connector.connect(this.hilbert.outAudio2, this.blockSizeOut2.inAudio);
        this.blockSizeIn.inBlockSize.write(PowerOf2.fromInt(2048));
        this.blockSizeOut1.inBlockSize.write(AudioConfig.getBlockSize());
        this.blockSizeOut2.inBlockSize.write(AudioConfig.getBlockSize());
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return new InputPort[]{this.blockSizeIn.inAudio};
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.blockSizeOut1.outAudio, this.blockSizeOut2.outAudio};
    }

    @Override
    public BounceletBase[] getParts() {
        return new BounceletBase[]{this.blockSizeIn, this.hilbert, this.blockSizeOut1, this.blockSizeOut2};
    }
}

