/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.test.HilbertFirEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;

public class HilbertBase
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public OutAudio outAudio1 = new OutAudio("out0", "Output audio wave 0\u00b0");
    public OutAudio outAudio2 = new OutAudio("out1", "Output audio wave 90\u00b0");
    private HilbertFirEngine[] engines;

    public HilbertBase() {
        super("audio.effect.fourier.filter.hilbert-base", "(Internal)");
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        WaveData wave = (WaveData)this.inAudio.peek();
        if (this.engines == null || this.engines.length != wave.nbChannels) {
            this.engines = new HilbertFirEngine[wave.nbChannels];
            int i = 0;
            while (i < this.engines.length) {
                this.engines[i] = new HilbertFirEngine();
                ++i;
            }
        }
    }

    private void process() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio1.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        this.outAudio2.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave1 = (WaveData)this.outAudio1.get();
        WaveData outWave2 = (WaveData)this.outAudio2.get();
        int chan = 0;
        while (chan < inWave.nbChannels) {
            float[] input = inWave.data[chan];
            float[] output1 = outWave1.data[chan];
            float[] output2 = outWave2.data[chan];
            this.engines[chan].process(input, output1, output2);
            ++chan;
        }
    }

    public int getLatency() {
        return HilbertFirEngine.getSampleLatency();
    }
}

