/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter.MelodyExtractor;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class Melody
extends Bouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InInt inCount = new InInt("count", "Maximum polyphony", 30, 1, 200);
    public InDouble inSeparation = new InDouble("separation", "Separation from neighboring noise [dB]", 7.5, 0.0, 100.0);
    public InDouble inDominance = new InDouble("dominance", "Domination over average signal [dB]", 5.0, -100.0, 100.0);
    public InDouble inMinFreq = new InDouble("minFreq", "Minimum extracted frequencies [Hz]", 150.0, 16.0, 1000.0);
    public OutSpectrum outMelody = new OutSpectrum("melody", "Melody");
    public OutSpectrum outRest = new OutSpectrum("rest", "Rest");
    private MelodyExtractor engine;

    public Melody() {
        super("audio.effect.spectrum.filter.melody", "Extract dominant slow melodies");
        super.setSkillType(SkillType.ADVANCED);
        this.inMinFreq.setScaleType(ScaleType.LOG2);
        this.inDominance.setScaleType(ScaleType.CUBEROOT);
        this.inMinFreq.setSkillType(SkillType.NORMAL);
        this.inCount.setSkillType(SkillType.ADVANCED);
        this.inSeparation.setSkillType(SkillType.ADVANCED);
        this.inDominance.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        SpectrumData data = (SpectrumData)this.inAudio.read();
        boolean changes = this.outMelody.prepare(data);
        this.outRest.prepare(data);
        if (changes || this.inCount.isModified() || this.inSeparation.isModified() || this.inDominance.isModified() || this.inMinFreq.isModified()) {
            float separationRatio = (float)AudioMath.dbToPowerLevel((Double)this.inSeparation.read());
            float dominationRatio = (float)AudioMath.dbToPowerLevel((Double)this.inDominance.read());
            double minFreq = (Double)this.inMinFreq.read();
            int minBin = (int)(minFreq * (double)data.getNbFrames() / (double)AudioConfig.getSampleRate());
            this.engine = new MelodyExtractor(data.nbBins, (Integer)this.inCount.read(), separationRatio, dominationRatio, minBin);
        }
    }

    private void process() {
        SpectrumData inSpectrum = (SpectrumData)this.inAudio.read();
        BitSet melodyBins = this.engine.process(inSpectrum.data);
        SpectrumData melodyData = (SpectrumData)this.outMelody.get();
        SpectrumData restData = (SpectrumData)this.outRest.get();
        int chan = 0;
        while (chan < inSpectrum.nbChannels) {
            Cmplx[] input = inSpectrum.data[chan];
            Cmplx[] melody = melodyData.data[chan];
            Cmplx[] rest = restData.data[chan];
            int i = 0;
            while (i < input.length) {
                if (melodyBins.get(i)) {
                    melody[i].set(input[i]);
                    rest[i].clear();
                } else {
                    melody[i].clear();
                    rest[i].set(input[i]);
                }
                ++i;
            }
            ++chan;
        }
    }
}

