/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Scrape
extends AudioExtractSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inStrength = new InDouble("strength", "Peeking strength", 1.1, 1.0, 2.0);
    public InDouble inWidth = new InDouble("width", "Coverage width", 1.02, 1.0, 1.1);
    public InDouble inLobeSize = new InDouble("binSize", "Main lobe bin size", 1.0, 0.0, 2.0);
    public OutSpectrum outNoise = new OutSpectrum("noise", "Output audio floor (noise)");
    public OutSpectrum outMelody = new OutSpectrum("melody", "Output audio peaks (melody)");
    private float[] mags;
    private double strength;
    private double width;
    private double lobeSize;

    public Scrape() {
        super("audio.effect.spectrum.filter.scrape", "Extract frequencies above the neighbouring floor level");
        super.setSkillType(SkillType.ADVANCED);
        this.inStrength.setScaleType(ScaleType.LOG2);
        this.inWidth.setScaleType(ScaleType.LOG2);
        this.inStrength.setSkillType(SkillType.ADVANCED);
        this.inWidth.setSkillType(SkillType.ADVANCED);
        this.inLobeSize.setSkillType(SkillType.EXPERT);
    }

    protected OutSpectrum getOutput1() {
        return this.outNoise;
    }

    protected OutSpectrum getOutput2() {
        return this.outMelody;
    }

    protected void setup() {
        if (this.inStrength.isModified()) {
            this.strength = (Double)this.inStrength.read();
        }
        if (this.inWidth.isModified()) {
            this.width = (Double)this.inWidth.read();
        }
        if (this.inLobeSize.isModified()) {
            this.lobeSize = (Double)this.inLobeSize.read();
        }
        SpectrumData inSpectrum = (SpectrumData)this.inAudio.peek();
        this.outMelody.prepare(inSpectrum);
        this.outNoise.prepare(inSpectrum);
        if (this.mags == null || this.mags.length != inSpectrum.nbBins) {
            this.mags = new float[inSpectrum.nbBins];
        }
    }

    public void process(int chan, Cmplx[] input, Cmplx[] floor, Cmplx[] peaks) {
        assert (input.length == peaks.length && input.length == floor.length);
        int i = 0;
        while (i < input.length) {
            this.mags[i] = input[i].magApprox();
            ++i;
        }
        assert (this.width >= 1.0);
        i = 0;
        while (i < input.length) {
            float mag;
            float upper;
            double startd = (double)i / this.width - this.lobeSize;
            double stopd = (double)i * this.width + this.lobeSize;
            int start = (int)Math.ceil(startd + 0.5);
            int stop = (int)Math.floor(stopd + 0.5);
            if (start < 0) {
                start = 0;
            }
            if (stop >= input.length) {
                stop = input.length - 1;
            }
            float minMag = Float.MAX_VALUE;
            int k = start;
            while (k <= stop) {
                float mag2 = this.mags[k];
                if (mag2 < minMag) {
                    minMag = mag2;
                }
                ++k;
            }
            float lower = this.peekInterpolated(this.mags, startd);
            if (lower < minMag) {
                minMag = lower;
            }
            if ((upper = this.peekInterpolated(this.mags, stopd)) < minMag) {
                minMag = upper;
            }
            if ((mag = this.mags[i]) < minMag) {
                minMag = mag;
            }
            if (mag > 0.0f) {
                float peakRatio = (mag - minMag) * (float)this.strength / mag;
                if (peakRatio > 1.0f) {
                    peakRatio = 1.0f;
                }
                float floorRatio = 1.0f - peakRatio;
                peaks[i].set(input[i].re * peakRatio, input[i].im * peakRatio);
                floor[i].set(input[i].re * floorRatio, input[i].im * floorRatio);
            } else {
                peaks[i].set(0.0f, 0.0f);
                floor[i].set(0.0f, 0.0f);
            }
            ++i;
        }
    }

    private float peekInterpolated(float[] mags, double position) {
        int pos0 = (int)Math.floor(position);
        int pos1 = pos0 + 1;
        float w1 = (float)position - (float)pos0;
        float w0 = 1.0f - w1;
        if (pos0 < 0) {
            pos0 = 0;
        } else if (pos0 >= mags.length) {
            pos0 = mags.length - 1;
        }
        if (pos1 < 0) {
            pos1 = 0;
        } else if (pos1 >= mags.length) {
            pos1 = mags.length - 1;
        }
        return mags[pos0] * w0 + mags[pos1] * w1;
    }
}

