/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Severity;

public class Shaper
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public InFrequencies inShape = new InFrequencies("shape", "Shape to apply");
    public InDouble inThreshold = new InDouble("threshold", "Threshold [dB]", -30.0, -100.0, 0.0);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");
    private double threshold;

    public Shaper() {
        super("audio.effect.spectrum.filter.shaper", "Apply a spectral shape to the given sound");
        super.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        if (this.inThreshold.isModified()) {
            SpectrumData in = (SpectrumData)this.inSpectrum.peek();
            this.threshold = AudioMath.dbToLevel((Double)this.inThreshold.read()) / (double)in.getNbFrames();
        }
    }

    private void process() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.read();
        boolean changes = this.outSpectrum.prepare(inData);
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        FrequenciesData shape = (FrequenciesData)this.inShape.read();
        if (changes) {
            if (inData.nbBins != shape.nbBins) {
                super.log(GraphErrorType.IllegalArgument, Severity.Error, "Spectrum has not the same size ({0}) as shape ({1})", inData.nbBins, shape.nbBins);
            }
            if (inData.nbChannels != shape.nbChannels) {
                super.log(GraphErrorType.IllegalArgument, Severity.Warning, "Spectrum has not the same number of channels ({0}) as shape ({1})", inData.nbChannels, shape.nbChannels);
            }
        }
        int chan = 0;
        while (chan < inData.nbChannels) {
            float[] curve = shape.data[chan % shape.nbChannels];
            Cmplx[] input = inData.data[chan];
            Cmplx[] output = outData.data[chan];
            assert (input.length == curve.length);
            int i = 0;
            while (i < input.length) {
                float level = input[i].mag();
                if ((double)level < this.threshold) {
                    output[i].set(0.0f, 0.0f);
                } else {
                    float correction = curve[i] / level;
                    output[i].set(input[i].re * correction, input[i].im * correction);
                }
                ++i;
            }
            ++chan;
        }
    }
}

