/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter.ShitExtractEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class ShitExtract
extends Bouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inThreshold = new InDouble("threshold", "Smell threshold", 0.4, 0.0, 1.0);
    public InInt inLength = new InInt("length", "Smell analysis length", 5, 1, 16);
    public OutSpectrum outShit = new OutSpectrum("out.shit", "Shit sounds");
    public OutSpectrum outFood = new OutSpectrum("out.food", "Food sounds");
    private Cmplx[] source;
    private ShitExtractEngine engine;
    private float threshold;

    public ShitExtract() {
        super("audio.effect.spectrum.filter.shit-x", "Extract shit from food");
        super.setSkillType(SkillType.ADVANCED);
        this.inThreshold.setSkillType(SkillType.SIMPLIFIED);
        this.inLength.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    public void setup() {
        SpectrumData data = (SpectrumData)this.inAudio.peek();
        if (this.engine == null || this.engine.nbBins != data.nbBins || this.inLength.isModified()) {
            this.engine = new ShitExtractEngine(data.nbBins, (Integer)this.inLength.read());
        }
        if (this.source == null || this.source.length != data.nbBins) {
            this.source = Cmplx.newArray(data.nbBins);
        }
        if (this.inThreshold.isModified()) {
            this.threshold = (float)((Double)this.inThreshold.read()).doubleValue();
        }
    }

    public void process() {
        SpectrumData input = (SpectrumData)this.inAudio.read();
        this.outFood.prepare(input);
        this.outShit.prepare(input);
        SpectrumData foog = (SpectrumData)this.outFood.get();
        SpectrumData shit = (SpectrumData)this.outShit.get();
        input.fillSum(this.source);
        this.engine.analyze(this.source, this.threshold);
        int chan = 0;
        while (chan < input.nbChannels) {
            this.engine.process(input.data[chan], foog.data[chan], shit.data[chan]);
            ++chan;
        }
    }
}

