/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class SpectralSlope
extends AudioMonoSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inSlope = new InDouble("coldth", "Slope from DC to Nyquist [dB/octave]", 0.0, -10.0, 10.0);
    public InDouble inGain = new InDouble("gain", "Gain [dB]", 0.0, -12.0, 12.0);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");
    private float[] coefficients;

    public SpectralSlope() {
        super("audio.effect.spectrum.filter.spectral-slope", "DC to Nyquist frequency slope", true);
        this.inSlope.setSkillType(SkillType.SIMPLIFIED);
    }

    protected void setup() {
        boolean isModified = this.inSlope.isModified();
        SpectrumData input = (SpectrumData)this.inAudio.peek();
        if (this.coefficients == null || input.nbBins != this.coefficients.length) {
            isModified = true;
        }
        if (isModified) {
            this.coefficients = new float[input.nbBins];
            double pinkEn = 0.0;
            int i = 0;
            while (i < this.coefficients.length) {
                double freq = i;
                double pink = 1.0 / Math.pow(freq, 0.5);
                if (Double.isNaN(pink) || Double.isInfinite(pink)) {
                    pink = 1.0;
                }
                pinkEn += pink * pink;
                ++i;
            }
            double pinkCor = Math.sqrt(this.coefficients.length) / Math.sqrt(pinkEn);
            double slope = (Double)this.inSlope.read() / 6.0;
            double energy = 0.0;
            int i2 = 0;
            while (i2 < this.coefficients.length) {
                double freq = i2;
                double value = slope < 0.0 ? 1.0 / Math.pow(freq, -slope) : Math.pow(freq, slope);
                if (Double.isNaN(value) || Double.isInfinite(value)) {
                    value = 1.0;
                }
                this.coefficients[i2] = (float)value;
                double expected = pinkCor / Math.pow(freq, 0.5);
                if (Double.isNaN(expected) || Double.isInfinite(expected)) {
                    expected = 1.0;
                }
                energy += value * value * expected * expected;
                ++i2;
            }
            float correction = (float)(Math.sqrt(this.coefficients.length) / Math.sqrt(energy));
            int i3 = 0;
            while (i3 < this.coefficients.length) {
                int n = i3++;
                this.coefficients[n] = this.coefficients[n] * correction;
            }
        }
    }

    public void process(Cmplx[] input, Cmplx[] output) {
        assert (input.length == output.length);
        float gain = (float)AudioMath.dbToLevel((Double)this.inGain.read());
        int i = 0;
        while (i < input.length) {
            output[i].set(input[i].re * this.coefficients[i] * gain, input[i].im * this.coefficients[i] * gain);
            ++i;
        }
    }
}

