/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class NoiseGate
extends AudioMonoSpectrumBouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input Spectrum");
    public InDouble inThreshold = new InDouble("threshold", "Noise threshold [db]", -30.0, -100.0, 100.0);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output Spectrum");
    private double powerGateLevel = 0.0;
    private boolean reverse = false;

    public NoiseGate() {
        super("audio.effect.spectrum.amplitude.noise.noise-gate", "Filter frequencies below a threshold", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inThreshold.setSkillType(SkillType.SIMPLIFIED);
    }

    protected void setup() {
        if (this.inThreshold.isModified()) {
            SpectrumData spectrum = (SpectrumData)this.inSpectrum.peek();
            double dbValue = (Double)this.inThreshold.read();
            if (dbValue <= 0.0) {
                double gateLevel = AudioMath.dbToLevel(dbValue);
                this.powerGateLevel = gateLevel * gateLevel / (double)spectrum.getNbFrames();
                this.reverse = false;
            } else {
                double gateLevel = AudioMath.dbToLevel(-dbValue);
                this.powerGateLevel = gateLevel * gateLevel / (double)spectrum.getNbFrames();
                this.reverse = true;
            }
        }
    }

    public void process(Cmplx[] input, Cmplx[] output) {
        assert (input.length == output.length);
        output[0].set(input[0]);
        Cmplx[] source = super.currentSource();
        int i = 1;
        while (i < input.length) {
            Cmplx src = source[i];
            double powerLevel = src.powerMag();
            if (powerLevel < this.powerGateLevel != this.reverse) {
                output[i].re = 0.0f;
                output[i].im = 0.0f;
            } else if (input != output) {
                output[i].re = input[i].re;
                output[i].im = input[i].im;
            }
            ++i;
        }
    }
}

