/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise;

import org.corebounce.decklight.bouncelets.audio.MaxBuffer;

public class NoiseLevelEngine {
    private int maxSize;
    private int maxCounter;
    private int minSize;
    private int cstSize;
    private MaxBuffer cstValues;
    private MaxBuffer maxValues;
    private MaxBuffer minValues;
    private float lowerLevel = 0.0f;
    private float upperLevel = 0.0f;

    public NoiseLevelEngine(int maxSize, int minSize, int cstSize) {
        if (maxSize < 1 || minSize < 1) {
            throw new IllegalArgumentException("Sizes must be both >= 1");
        }
        this.cstValues = new MaxBuffer(cstSize, 0.0f);
        this.maxValues = new MaxBuffer(maxSize, 0.0f);
        this.minValues = new MaxBuffer(minSize, 0.0f);
        this.setSizes(maxSize, minSize, cstSize);
        this.minValues.push(0.0f);
        this.cstValues.push(0.0f);
    }

    public void setSizes(int maxSize, int minSize, int cstSize) {
        this.maxSize = maxSize;
        this.minSize = minSize;
        this.cstSize = cstSize;
        this.maxCounter %= maxSize;
        this.cstValues.setSize(this.cstSize);
        this.maxValues.setSize(this.maxSize);
        this.minValues.setSize(this.minSize);
    }

    public void push(float value) {
        this.lowerLevel = -this.cstValues.push(-value);
        float max = this.maxValues.push(value);
        ++this.maxCounter;
        if (this.maxCounter >= this.maxSize) {
            this.maxCounter = 0;
            this.upperLevel = -this.minValues.push(-max);
        }
    }

    public float getLowerLevel() {
        return this.lowerLevel;
    }

    public float getUpperLevel() {
        return this.upperLevel;
    }
}

