/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise;

import org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise.NoiseLevelEngine;

public class NoiseSpectrumEngine {
    private NoiseLevelEngine[] levels;
    private double peakLevel;
    private float[] history;

    public NoiseSpectrumEngine(int nbBins, int maxSize, int minSize, int cstSize) {
        this.setSizes(nbBins, maxSize, minSize, cstSize);
    }

    public void setSizes(int nbBins, int maxSize, int minSize, int cstSize) {
        if (this.levels == null || this.levels.length != nbBins) {
            this.levels = new NoiseLevelEngine[nbBins];
            int i = 0;
            while (i < nbBins) {
                this.levels[i] = new NoiseLevelEngine(maxSize, minSize, cstSize);
                ++i;
            }
            this.history = new float[nbBins];
        } else {
            int i = 0;
            while (i < nbBins) {
                this.levels[i].setSizes(maxSize, minSize, cstSize);
                ++i;
            }
        }
    }

    public void push(int bin, double value) {
        this.levels[bin].push((float)value);
        if (value > this.peakLevel) {
            this.peakLevel = value;
        }
    }

    public double getLowerLevel(int bin) {
        return this.levels[bin].getLowerLevel();
    }

    public double getUpperLevel(int bin) {
        return this.levels[bin].getUpperLevel();
    }

    public float[] getHistory() {
        return this.history;
    }

    public double getPeak() {
        return this.peakLevel;
    }

    public double readPeak(double decayFactor) {
        double result = this.peakLevel;
        this.peakLevel *= decayFactor;
        return result;
    }
}

