/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.noise;

import java.util.Arrays;
import org.corebounce.common.math.Cmplx;

public class ProfiledNoiseRemovalEngine {
    private final int nbBins;
    private final int nbSkip;
    private final float[] minLevels;
    private final float[] maxLevels;
    private boolean analyzing = true;
    private int countDown;
    private long nbSamples;
    private final float[] subLevels;
    private final float[] cutLevels;
    private float biasFactor = 1.0f;

    public ProfiledNoiseRemovalEngine(int nbBins, int nbSkip) {
        this.nbBins = nbBins;
        this.nbSkip = nbSkip;
        this.minLevels = new float[nbBins];
        this.maxLevels = new float[nbBins];
        this.subLevels = new float[nbBins];
        this.cutLevels = new float[nbBins];
        this.startAnalysis();
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public void startAnalysis() {
        Arrays.fill(this.minLevels, Float.POSITIVE_INFINITY);
        Arrays.fill(this.maxLevels, Float.NEGATIVE_INFINITY);
        this.continueAnalysis();
    }

    public void continueAnalysis() {
        this.countDown = this.nbSkip + 1;
        this.analyzing = true;
        this.nbSamples = 0L;
    }

    public void analyze(Cmplx[] input) {
        if (input.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        boolean nonZero = false;
        int i = 0;
        while (i < this.nbBins) {
            float powerMag = input[i].powerMag();
            if (powerMag > 0.0f) {
                nonZero = true;
                if (this.countDown == 0 && powerMag < this.minLevels[i]) {
                    this.minLevels[i] = powerMag;
                }
                if (powerMag > this.maxLevels[i]) {
                    this.maxLevels[i] = powerMag;
                }
            }
            ++i;
        }
        if (nonZero) {
            ++this.nbSamples;
            if (this.countDown > 0) {
                --this.countDown;
            }
        }
    }

    public boolean isAnalyzing() {
        return this.analyzing;
    }

    public void startProcessing(boolean continuousOnly, float cutSubBalance) {
        if (cutSubBalance < 0.0f || cutSubBalance > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.analyzing = false;
        int i = 0;
        while (i < this.nbBins) {
            float min = this.minLevels[i];
            float max = this.maxLevels[i] * ((float)(this.nbSamples + 1L) / (float)this.nbSamples);
            assert (min <= max);
            if (continuousOnly) {
                this.cutLevels[i] = min;
                this.subLevels[i] = min * cutSubBalance;
            } else {
                this.cutLevels[i] = max;
                this.subLevels[i] = min + (max - min) * cutSubBalance;
            }
            ++i;
        }
    }

    public void setBiasFactor(float value) {
        this.biasFactor = value;
    }

    public void process(Cmplx[] input, Cmplx[] output) {
        if (input.length != this.nbBins || output.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.nbBins) {
            float srcMag = input[i].powerMag();
            float cut = this.cutLevels[i] * this.biasFactor;
            float sub = this.subLevels[i] * this.biasFactor;
            if (srcMag <= cut || srcMag <= sub) {
                output[i].set(0.0f, 0.0f);
            } else {
                output[i].set(input[i]);
                float dstMag = srcMag - sub;
                float ratio = dstMag / srcMag;
                output[i].mul(ratio);
            }
            ++i;
        }
    }
}

