/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.common.dsp.UnityRoots;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Log;

public class Detune
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input Spectrum");
    public InDouble inShift = new InDouble("shift", "frequency shift [Hz]", 0.0, -AudioConfig.MAX_FREQUENCY, AudioConfig.MAX_FREQUENCY);
    public InPowerOf2 inZeroPadding = new InPowerOf2(true, "zeroPadding", "Zero padding amount (increase resolution)", PowerOf2.p16);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output Spectrum");
    private int binShift;
    private int intPadding;
    private int nbPhases;
    private int curPhase;
    private int binSkew;
    private Cmplx[] roots;
    private WindowInfo windowing;

    public Detune() {
        super("audio.effect.spectrum.pitch.detune", "Detune by shifting the frequencies");
        super.setSkillType(SkillType.ADVANCED);
        this.inShift.setScaleType(ScaleType.CUBEROOT);
        this.inShift.setSkillType(SkillType.SIMPLIFIED);
        this.inZeroPadding.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        SpectrumData spectrum = (SpectrumData)this.inSpectrum.peek();
        if (this.inShift.isModified() || this.inZeroPadding.isModified() || spectrum.windowing.isWindowModified()) {
            double freqShift = (Double)this.inShift.read();
            this.intPadding = ((PowerOf2)((Object)this.inZeroPadding.read())).intValue();
            int extPadding = spectrum.windowing.getZeroPadding().intValue();
            double binSize = (double)AudioConfig.getSampleRate() / (double)(spectrum.getNbFrames() * extPadding * this.intPadding);
            this.binShift = freqShift > 0.0 ? (int)(freqShift / binSize + 0.5) : (int)(freqShift / binSize - 0.5);
            Log.debug("Bin shift: {0}", this.binShift);
            this.nbPhases = spectrum.windowing.getOverlapping().intValue() * extPadding * this.intPadding;
            this.curPhase %= this.nbPhases;
            this.roots = UnityRoots.getInstance().getRoots(this.nbPhases, this.nbPhases);
            this.binSkew = this.binShift < 0 ? -this.binShift % this.nbPhases : this.nbPhases - this.binShift % this.nbPhases;
            this.windowing = new WindowInfo(spectrum.windowing);
            this.windowing.setZeroPadding((PowerOf2)((Object)this.inZeroPadding.read()));
        }
        if (!spectrum.windowing.isWindowModified()) {
            this.windowing.setWindowModified(false);
        }
    }

    private void process() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.read();
        int nbBins = (inData.nbBins - 1) * this.intPadding + 1;
        this.outSpectrum.prepare(inData.nbChannels, nbBins, inData.nbLayers, inData.hqxMode, this.windowing);
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        int chan = 0;
        while (chan < inData.nbChannels) {
            Cmplx[] input = inData.data[chan];
            Cmplx[] output = outData.data[chan];
            output[0].copyFrom(input[0]);
            int i = 1;
            while (i < output.length) {
                output[i].set(0.0f, 0.0f);
                ++i;
            }
            i = 1;
            while (i < input.length) {
                int si = i * this.intPadding;
                int di = si + this.binShift;
                if (di >= 1 && di < output.length) {
                    output[di].copyFrom(input[i]);
                    if (this.intPadding > 1) {
                        output[di].mul(this.intPadding);
                    }
                    if (this.curPhase != 0) {
                        int phaseSkew = this.binSkew * this.curPhase % this.nbPhases;
                        output[di].mul(this.roots[phaseSkew]);
                    }
                }
                ++i;
            }
            ++chan;
        }
        this.curPhase = (this.curPhase + 1) % this.nbPhases;
    }
}

