/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import java.util.Arrays;
import org.corebounce.common.dsp.BooFFT;
import org.corebounce.common.dsp.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.DetuneEngine;

public class P1Engine {
    private static final float[] HANN_COEFS = Windows.HannCoefs;
    private static final float SQRT_HALF = (float)Math.sqrt(0.5);
    private final int nbBands;
    private final int blockSize;
    private final int shiftSize;
    private final double sampleRate;
    private final double minFrequency;
    private final double maxFrequency;
    private final int nbFreqs;
    private final BooFFT fft;
    private final int[] lowers;
    private final int[] uppers;
    private final DetuneEngine[] detuners;
    private final float[] incomming;
    private final Cmplx[] spectrum0;
    private final Cmplx[] spectrum1;
    private final Cmplx[] spectrum2;
    private final float[] inverseWindow;
    private final float[] buffer1;
    private final float[] buffer2;
    private final float[][] bands1;
    private final float[][] bands2;
    private final float[] summed;
    private final float[] outBlock1;
    private final float[] outBlock2;
    private int mergeIndex = 0;
    private double ratio;

    public P1Engine(int nbBands, int blockSize, int overlap, double sampleRate, double minFrequency, double maxFrequency) {
        this.nbBands = nbBands;
        this.blockSize = blockSize;
        this.shiftSize = blockSize / overlap;
        this.nbFreqs = blockSize / 2;
        this.sampleRate = sampleRate;
        this.minFrequency = minFrequency;
        this.maxFrequency = maxFrequency;
        this.fft = BooFFT.getInstance(blockSize / 2);
        this.lowers = new int[nbBands];
        this.uppers = new int[nbBands];
        this.detuners = new DetuneEngine[nbBands];
        this.incomming = new float[blockSize];
        this.spectrum0 = Cmplx.newArray(this.nbFreqs + 1);
        this.spectrum1 = Cmplx.newArray(this.nbFreqs + 1);
        this.spectrum2 = Cmplx.newArray(this.nbFreqs + 1);
        this.inverseWindow = new float[this.shiftSize];
        this.buffer1 = new float[blockSize];
        this.buffer2 = new float[blockSize];
        this.bands1 = new float[nbBands][blockSize];
        this.bands2 = new float[nbBands][blockSize];
        this.summed = new float[this.shiftSize];
        this.outBlock1 = new float[this.shiftSize];
        this.outBlock2 = new float[this.shiftSize];
        float[] hann = WindowFactory.getWindow(WindowType.Hann, blockSize);
        Windows.fillInverseWindow(hann, hann, this.inverseWindow, blockSize, this.shiftSize);
    }

    public void setRatio(double ratio) {
        if (ratio == this.ratio) {
            return;
        }
        this.ratio = ratio;
        this.lowers[0] = 0;
        this.uppers[this.nbBands - 1] = this.nbFreqs;
        System.out.println("*** Engine: " + this.minFrequency + " .. " + this.maxFrequency);
        double nyquist = this.sampleRate / 2.0;
        double logLower = Math.log(this.minFrequency);
        double logUpper = Math.log(this.maxFrequency);
        double logStart = logLower;
        int startBin = P1Engine.frequencyToBin(this.minFrequency, this.nbFreqs, nyquist);
        if (startBin < 1) {
            startBin = 1;
        }
        int i = 0;
        while (i < this.nbBands) {
            int stopBin = P1Engine.getNextStopBin(startBin, logStart, logUpper, this.nbFreqs, nyquist, this.nbBands - i);
            double stop = P1Engine.binToFrequency(stopBin, this.nbFreqs, nyquist);
            double logStop = Math.log(stop);
            if (stopBin > this.nbFreqs) {
                stopBin = this.nbFreqs;
            }
            this.lowers[i] = startBin;
            this.uppers[i] = stopBin;
            double srcFreq = Math.exp((logStart + logStop) / 2.0);
            System.out.format("Band %d: %d - %d = %f\n", i, startBin, stopBin, srcFreq);
            double dstFreq = srcFreq * ratio;
            double shift = dstFreq - srcFreq;
            this.detuners[i] = new DetuneEngine(this.sampleRate, this.blockSize, 0);
            this.detuners[i].setShift(shift);
            logStart = logStop;
            startBin = stopBin;
            ++i;
        }
    }

    public static double binToFrequency(int binNum, int nbFreqs, double nyquist) {
        return (double)binNum * nyquist / (double)nbFreqs;
    }

    public static int frequencyToBin(double frequency, int nbFreqs, double nyquist) {
        return (int)(frequency * (double)nbFreqs / nyquist + 0.5);
    }

    public static int getNextStopBin(int startBin, double logStart, double logUpper, int nbFreqs, double nyquist, int remBands) {
        double logStop = logStart + (logUpper - logStart) / (double)remBands;
        double stop = Math.exp(logStop);
        int stopBin = P1Engine.frequencyToBin(stop, nbFreqs, nyquist);
        if (stopBin - startBin < 1) {
            stopBin = startBin + 1;
        }
        return stopBin;
    }

    public void processAdd(float[] input, float[] output) {
        if (input.length != this.shiftSize || output.length != this.shiftSize) {
            throw new IllegalArgumentException();
        }
        Arrays.fill(this.summed, 0.0f);
        System.arraycopy(this.incomming, this.shiftSize, this.incomming, 0, this.blockSize - this.shiftSize);
        System.arraycopy(input, 0, this.incomming, this.blockSize - this.shiftSize, this.shiftSize);
        this.fft.forwR2C(this.incomming, this.spectrum0);
        Windows.convolve2(this.spectrum0, HANN_COEFS[0], HANN_COEFS[1]);
        int band = 0;
        while (band < this.nbBands) {
            int lower = this.lowers[band];
            int upper = this.uppers[band];
            int i = 0;
            while (i < lower) {
                this.spectrum1[i].set(0.0f, 0.0f);
                this.spectrum2[i].set(0.0f, 0.0f);
                ++i;
            }
            i = lower;
            while (i < upper) {
                Cmplx value = this.spectrum0[i];
                this.spectrum1[i].set(value.re, value.im);
                this.spectrum2[i].set(-value.im, value.re);
                ++i;
            }
            i = upper;
            while (i < this.spectrum0.length) {
                this.spectrum1[i].set(0.0f, 0.0f);
                this.spectrum2[i].set(0.0f, 0.0f);
                ++i;
            }
            Windows.convolve2(this.spectrum1, HANN_COEFS[0], HANN_COEFS[1]);
            Windows.convolve2(this.spectrum2, HANN_COEFS[0], HANN_COEFS[1]);
            this.fft.backC2R(this.spectrum1, this.buffer1);
            this.fft.backC2R(this.spectrum2, this.buffer2);
            float[] mergeBuffer1 = this.bands1[band];
            float[] mergeBuffer2 = this.bands2[band];
            int i2 = 0;
            while (i2 < this.blockSize - this.shiftSize) {
                int n = (this.mergeIndex + i2) % this.blockSize;
                mergeBuffer1[n] = mergeBuffer1[n] + this.buffer1[i2];
                int n2 = (this.mergeIndex + i2) % this.blockSize;
                mergeBuffer2[n2] = mergeBuffer2[n2] + this.buffer2[i2];
                ++i2;
            }
            i2 = this.blockSize - this.shiftSize;
            while (i2 < this.blockSize) {
                mergeBuffer1[(this.mergeIndex + i2) % this.blockSize] = this.buffer1[i2];
                mergeBuffer2[(this.mergeIndex + i2) % this.blockSize] = this.buffer2[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.shiftSize) {
                this.outBlock1[i2] = mergeBuffer1[(this.mergeIndex + i2) % this.blockSize] * this.inverseWindow[i2];
                this.outBlock2[i2] = mergeBuffer2[(this.mergeIndex + i2) % this.blockSize] * this.inverseWindow[i2];
                int n = i2;
                this.summed[n] = this.summed[n] + (this.outBlock1[i2] + this.outBlock2[i2]) * SQRT_HALF;
                ++i2;
            }
            this.detuners[band].processAdd(this.outBlock2, this.outBlock1, output);
            ++band;
        }
        this.mergeIndex = (this.mergeIndex + this.shiftSize) % this.blockSize;
    }

    public int getSampleLatency() {
        int result = this.blockSize - this.shiftSize;
        return result;
    }
}

