/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import java.util.Arrays;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.FastMath;
import org.corebounce.common.math.ParabolicInterpolator;
import org.corebounce.common.math.ShellSort;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.utils.Log;

public abstract class PhaseLockedVocoder
extends Bouncelet {
    protected static final double MIN_FREQ = 20.0;
    protected static final double MAX_FREQ = 22000.0;
    private static final int COUNTER_RESET = 20;
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public InSpectrumPreset<PhaseLockedVocoder, Preset> inPreset = new InSpectrumPreset(Preset.class, "Presets", "Predefined settings", Preset.Normal);
    public InputPort<PickMode> inPickMode = new InputPort<PickMode>(PickMode.class, "pickMode", "Peak picking mode", PickMode.LogScale);
    public InInt inPeakCount = new InInt("peakCount", "Maximum number of peak frequencies", 200, 10, 500);
    public InBoolean inFastApprox = new InBoolean("approx", "Use faster approximations", false);
    public InBoolean inMerging = new InBoolean("merging", "Allow band merging (LogScale mode only)", true);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");
    private float[] srcPowerMags;
    private float[] inputPowerMags;
    private int[] peakIndexes;
    private int maxPeaks;
    private int nbPeaks;
    private int[] hardBounds;
    private int[] bounds;
    private double[] freqs;
    private Cmplx temp = Cmplx.newCmplx();
    private Cmplx rotation = Cmplx.newCmplx();
    private Cmplx[][][] lastShifts;
    private int counter;
    private int fftSize;

    public PhaseLockedVocoder(String name, String description, boolean isTarget) {
        super(name, description, isTarget);
        this.initialize();
    }

    public PhaseLockedVocoder(String name, String description) {
        super(name, description);
        this.initialize();
    }

    private void initialize() {
        super.setSkillType(SkillType.ADVANCED);
        this.inPreset.setSkillType(SkillType.NORMAL);
        this.inPeakCount.setSkillType(SkillType.ADVANCED);
        this.inPeakCount.setScaleType(ScaleType.CUBEROOT);
        this.inPickMode.setSkillType(SkillType.ADVANCED);
        this.inFastApprox.setSkillType(SkillType.ADVANCED);
        this.inMerging.setSkillType(SkillType.EXPERT);
    }

    protected final double binToHz(double freq) {
        return freq * (double)AudioConfig.getSampleRate() / (double)this.fftSize;
    }

    protected final double hzToBin(double freq) {
        return freq * (double)this.fftSize / (double)AudioConfig.getSampleRate();
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    protected void setup() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.peek();
        boolean changes = this.outSpectrum.prepare(inData);
        boolean bl = inData.windowing.isWindowModified() || this.inPeakCount.isModified() || this.inPickMode.isModified();
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        if (changes |= bl) {
            Log.debug("LockedVocoder reseting", new Object[0]);
            this.srcPowerMags = new float[outData.nbBins];
            this.inputPowerMags = new float[outData.nbBins];
            this.peakIndexes = new int[outData.nbBins];
            this.maxPeaks = (Integer)this.inPeakCount.read();
            if (this.inPickMode.read() == PickMode.Amplitude && this.maxPeaks == (Integer)this.inPeakCount.getMaxValue() && this.maxPeaks < inData.nbBins / 2) {
                this.maxPeaks = inData.nbBins / 2;
            }
            this.hardBounds = new int[this.maxPeaks - 1];
            this.bounds = new int[this.maxPeaks - 1];
            this.freqs = new double[this.maxPeaks];
            this.fillHardBounds();
            this.lastShifts = new Cmplx[this.getNumberOfResults()][][];
            int r = 0;
            while (r < this.getNumberOfResults()) {
                this.lastShifts[r] = Cmplx.newArray(outData.nbChannels, outData.nbBins);
                int i = 0;
                while (i < this.lastShifts[r].length) {
                    int j = 0;
                    while (j < this.lastShifts[r][i].length) {
                        this.lastShifts[r][i][j].set(1.0f, 0.0f);
                        ++j;
                    }
                    ++i;
                }
                ++r;
            }
            this.fftSize = inData.getNbFrames();
        }
    }

    protected void process() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.read();
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        int overlap = inData.windowing.getOverlapping().intValue();
        this.analyze(inData.data, this.srcPowerMags);
        int chan = 0;
        while (chan < inData.nbChannels) {
            this.fillPowerMags(inData.data[chan], this.inputPowerMags);
            Cmplx[] input = this.preSynthesize(inData.data[chan], this.nbPeaks, this.bounds);
            this.synthesize(input, outData.data[chan], overlap, chan);
            ++chan;
        }
        this.counter = (this.counter + 1) % 20;
    }

    protected Cmplx[] preSynthesize(Cmplx[] input, int nbPeaks, int[] bounds) {
        return input;
    }

    private void analyze(Cmplx[][] input, float[] powerMags) {
        PickMode mode = this.inPickMode.read();
        this.fillPowerMags(input, powerMags);
        if (mode.equals((Object)PickMode.Amplitude)) {
            this.pickPeaks(powerMags, this.maxPeaks);
            this.fillBounds();
        } else if (mode.equals((Object)PickMode.LogScale)) {
            this.pickBounds();
            this.fillPeaks();
            if (((Boolean)this.inMerging.read()).booleanValue()) {
                this.mergePeaks();
            }
        }
        this.fillPeakFrequencies();
    }

    private void fillPowerMags(Cmplx[][] input, float[] powerMags) {
        Cmplx[] in = input[0];
        int i = 0;
        while (i < in.length) {
            powerMags[i] = in[i].powerMag();
            ++i;
        }
        int chan = 1;
        while (chan < input.length) {
            in = input[chan];
            int i2 = 0;
            while (i2 < in.length) {
                int n = i2;
                powerMags[n] = powerMags[n] + in[i2].powerMag();
                ++i2;
            }
            ++chan;
        }
    }

    private void fillPowerMags(Cmplx[] in, float[] powerMags) {
        int i = 0;
        while (i < in.length) {
            powerMags[i] = in[i].powerMag();
            ++i;
        }
    }

    private void pickPeaks(float[] mags, int maxPeaks) {
        this.nbPeaks = 0;
        int i = 0;
        while (i < mags.length) {
            if (this.isPeak(i)) {
                this.peakIndexes[this.nbPeaks++] = i;
            }
            ++i;
        }
        if (maxPeaks < (Integer)this.inPeakCount.getMaxValue() && this.nbPeaks > maxPeaks) {
            ShellSort.sort(this.peakIndexes, mags, this.nbPeaks);
            if (this.nbPeaks > maxPeaks) {
                this.nbPeaks = maxPeaks;
            }
            Arrays.sort(this.peakIndexes, 0, this.nbPeaks);
        }
    }

    private void fillBounds() {
        int p = 0;
        while (p < this.nbPeaks - 1) {
            int start = this.peakIndexes[p];
            int stop = this.peakIndexes[p + 1];
            assert (start < stop);
            double min = Double.MAX_VALUE;
            int bound = (start + stop) / 2;
            int i = start;
            while (i < stop) {
                double level = this.getSrcMag(i) + this.getSrcMag(i + 1);
                if (level < min) {
                    min = level;
                    bound = i;
                }
                ++i;
            }
            this.bounds[p] = bound;
            ++p;
        }
    }

    protected double minFreq() {
        return 20.0;
    }

    protected double maxFreq() {
        return 22000.0;
    }

    private void fillHardBounds() {
        this.nbPeaks = this.maxPeaks;
        double minFreq = this.minFreq();
        double maxFreq = this.maxFreq();
        double logMax = Math.log(maxFreq);
        double logMin = Math.log(minFreq);
        int prevBin = 0;
        int p = 0;
        while (p < this.nbPeaks - 1) {
            double logPos = logMin + (logMax - logMin) * (double)(p + 1) / (double)this.nbPeaks;
            double pos = Math.exp(logPos);
            int binNum = (int)(pos * (double)this.srcPowerMags.length / maxFreq + 0.5);
            if (binNum < prevBin + 1) {
                binNum = prevBin + 1;
            }
            if (binNum >= this.srcPowerMags.length) {
                this.nbPeaks = p;
                break;
            }
            this.hardBounds[p] = binNum;
            prevBin = binNum;
            ++p;
        }
    }

    private void pickBounds() {
        int p = 0;
        while (p < this.nbPeaks - 1) {
            int start = p == 0 ? 1 : (this.hardBounds[p - 1] + this.hardBounds[p] + 1) / 2;
            int stop = p == this.nbPeaks - 2 ? this.srcPowerMags.length - 2 : (this.hardBounds[p] + this.hardBounds[p + 1]) / 2;
            double min = Double.MAX_VALUE;
            int bound = this.hardBounds[p];
            int i = start;
            while (i < stop) {
                double value = this.getSrcMag(i) + this.getSrcMag(i + 1);
                if (value < min) {
                    min = value;
                    bound = i + 1;
                }
                ++i;
            }
            this.bounds[p] = bound;
            ++p;
        }
    }

    private void fillPeaks() {
        int p = 0;
        while (p < this.nbPeaks) {
            int upper;
            int lower = p == 0 ? 0 : this.bounds[p - 1];
            int n = upper = p == this.nbPeaks - 1 ? this.srcPowerMags.length - 1 : this.bounds[p];
            assert (lower < upper);
            double max = -1.0;
            int peakIndex = (upper + lower) / 2;
            int i = lower;
            while (i < upper) {
                double level = this.srcPowerMags[i];
                if (level > max) {
                    max = level;
                    peakIndex = i;
                }
                ++i;
            }
            while (!this.isLocalPeak(peakIndex)) {
                double next;
                double prev = this.getSrcMag(peakIndex - 1);
                if (prev == (next = (double)this.getSrcMag(peakIndex + 1))) break;
                if (prev > next) {
                    if (peakIndex == 0) break;
                    --peakIndex;
                    continue;
                }
                if (peakIndex == this.srcPowerMags.length - 1) break;
                ++peakIndex;
            }
            this.peakIndexes[p] = peakIndex;
            ++p;
        }
    }

    private void mergePeaks() {
        int mergeBin = -1;
        int mergeBand = -1;
        int upperBin = -1;
        int p = 0;
        while (p < this.nbPeaks) {
            int index = this.peakIndexes[p];
            int lower = this.getLowerBound(p);
            int upper = this.getUpperBound(p);
            if (upper > lower) {
                if (index >= lower && index < upper) {
                    this.mergeAnyPeakUpper(mergeBand, p, upperBin);
                    mergeBand = p;
                    mergeBin = index;
                    upperBin = -1;
                } else if (this.peakIndexes[p] == mergeBin) {
                    upperBin = upper;
                } else {
                    this.mergeAnyPeakUpper(mergeBand, p, upperBin);
                    mergeBand = -1;
                }
            }
            ++p;
        }
        this.mergeAnyPeakUpper(mergeBand, this.nbPeaks - 1, upperBin);
        mergeBin = -1;
        mergeBand = -1;
        int lowerBin = -1;
        int p2 = this.nbPeaks - 1;
        while (p2 >= 0) {
            int index = this.peakIndexes[p2];
            int lower = this.getLowerBound(p2);
            int upper = this.getUpperBound(p2);
            if (upper > lower) {
                if (index >= lower && index < upper) {
                    this.mergeAnyPeakLower(mergeBand, p2, lowerBin);
                    mergeBand = p2;
                    mergeBin = index;
                    lowerBin = -1;
                } else if (this.peakIndexes[p2] == mergeBin) {
                    lowerBin = lower;
                } else {
                    this.mergeAnyPeakLower(mergeBand, p2, lowerBin);
                    mergeBand = -1;
                }
            }
            --p2;
        }
        this.mergeAnyPeakLower(mergeBand, 0, lowerBin);
    }

    private void mergeAnyPeakUpper(int centerBand, int upperBand, int upperBin) {
        if (centerBand < 0 || upperBin < 0) {
            return;
        }
        int i = centerBand;
        while (i < upperBand) {
            this.bounds[i] = upperBin;
            ++i;
        }
    }

    private void mergeAnyPeakLower(int centerBand, int lowerBand, int lowerBin) {
        if (centerBand < 0 || lowerBin < 0) {
            return;
        }
        int i = centerBand;
        while (i > lowerBand) {
            this.bounds[i - 1] = lowerBin;
            --i;
        }
    }

    private int getUpperBound(int p) {
        return p == this.nbPeaks - 1 ? this.srcPowerMags.length - 1 : this.bounds[p];
    }

    private int getLowerBound(int p) {
        return p == 0 ? 0 : this.bounds[p - 1];
    }

    private void fillPeakFrequencies() {
        int p = 0;
        while (p < this.nbPeaks) {
            double next;
            int index = this.peakIndexes[p];
            double cur = AudioMath.powerLevelToDb0(this.getSrcMag(index));
            double prev = AudioMath.powerLevelToDb0(this.getSrcMag(index - 1));
            double center = (double)index + ParabolicInterpolator.interpolateX(prev, cur, next = AudioMath.powerLevelToDb0(this.getSrcMag(index + 1)));
            if (Double.isInfinite(center) || Double.isNaN(center)) {
                center = index;
            }
            this.freqs[p] = center;
            ++p;
        }
    }

    private boolean isPeak(int index) {
        float current = this.getSrcMag(index);
        float prev = this.getSrcMag(index - 1);
        float next = this.getSrcMag(index + 1);
        float prev2 = this.getSrcMag(index - 2);
        float next2 = this.getSrcMag(index + 2);
        return current > prev && current > prev2 && current >= next && current >= next2;
    }

    private boolean isLocalPeak(int index) {
        float current = this.getSrcMag(index);
        float prev = this.getSrcMag(index - 1);
        float next = this.getSrcMag(index + 1);
        return current > prev && current >= next;
    }

    private float getSrcMag(int index) {
        if (index < 0 || index >= this.srcPowerMags.length) {
            return 0.0f;
        }
        return this.srcPowerMags[index];
    }

    protected float getNearestPeakMag(int binNum) {
        while (binNum > 0 && binNum < this.srcPowerMags.length && !this.isLocalPeak(binNum)) {
            float prevMag = this.getSrcMag(binNum - 1);
            float nextMag = this.getSrcMag(binNum + 1);
            if (nextMag > prevMag) {
                ++binNum;
                continue;
            }
            --binNum;
        }
        return this.getSrcMag(binNum);
    }

    private float getInputMag(int index) {
        if (index < 0 || index >= this.srcPowerMags.length) {
            return 0.0f;
        }
        return this.inputPowerMags[index];
    }

    protected int getNumberOfResults() {
        return 1;
    }

    protected abstract double getModifiedFreq(int var1, double var2);

    protected float getModifiedLevel(int resultNum, double freq) {
        return 1.0f;
    }

    private void synthesize(Cmplx[] in, Cmplx[] out, int overlap, int chan) {
        int i = 0;
        while (i < out.length) {
            out[i].clear();
            ++i;
        }
        boolean fastApprox = (Boolean)this.inFastApprox.read();
        int r = 0;
        while (r < this.getNumberOfResults()) {
            int p = 0;
            while (p < this.nbPeaks) {
                double dstFreq;
                int startIndex = p == 0 ? 0 : this.bounds[p - 1];
                int stopIndex = p == this.nbPeaks - 1 ? out.length : this.bounds[p];
                double srcFreq = this.freqs[p];
                float level = this.getModifiedLevel(r, srcFreq);
                if (stopIndex > startIndex && level != 0.0f && (dstFreq = this.getModifiedFreq(r, srcFreq)) > 0.0) {
                    double binShift = dstFreq - srcFreq;
                    if (fastApprox) {
                        binShift = (int)(binShift + 0.5);
                    }
                    double phaseSkew = -binShift * 2.0 * Math.PI / (double)overlap;
                    if (fastApprox) {
                        this.rotation.re = (float)FastMath.fastCos(phaseSkew);
                        this.rotation.im = (float)FastMath.fastSin(phaseSkew);
                    } else {
                        this.rotation.re = (float)Math.cos(phaseSkew);
                        this.rotation.im = (float)Math.sin(phaseSkew);
                    }
                    Cmplx lastShift = this.lastShifts[r][chan][this.peakIndexes[p]];
                    this.rotation.mul(lastShift);
                    if (this.counter == 0) {
                        this.rotation.mul(1.0f / this.rotation.mag());
                    }
                    if (Float.isNaN(this.rotation.re) || Float.isNaN(this.rotation.im)) {
                        throw new IllegalStateException();
                    }
                    this.shiftPeakRegion(in, out, chan, fastApprox, startIndex, stopIndex, binShift, level);
                    int i2 = startIndex;
                    while (i2 < stopIndex) {
                        this.lastShifts[r][chan][i2].set(this.rotation);
                        ++i2;
                    }
                }
                ++p;
            }
            ++r;
        }
    }

    private void shiftPeakRegion(Cmplx[] in, Cmplx[] out, int chan, boolean fastApprox, int startIndex, int stopIndex, double binShift, float level) {
        int src = startIndex;
        while (src < stopIndex) {
            int dst = (int)((double)src + binShift + 0.5);
            if (dst >= 0 && dst < in.length) {
                this.temp.set(in[src]);
                this.temp.mul(this.rotation);
                if (!fastApprox) {
                    double org = (double)dst - binShift;
                    int org0 = (int)org;
                    int org1 = org0 + 1;
                    double w1 = org - (double)org0;
                    double mag0 = Math.sqrt(this.getInputMag(org0));
                    double mag1 = Math.sqrt(this.getInputMag(org1));
                    double mag = mag0 + (mag1 - mag0) * w1;
                    double cur = this.temp.magApprox();
                    if (cur > 0.0) {
                        this.temp.mul((float)(mag / cur));
                    }
                }
                this.temp.mul(level);
                out[dst].add(this.temp);
            }
            ++src;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PickMode {
        Amplitude,
        LogScale;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Preset implements Presetter<PhaseLockedVocoder>
    {
        Normal("Normal"){

            public void apply(PhaseLockedVocoder bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(bouncelet.inPeakCount, 250);
                setter.setPortValue(bouncelet.inFastApprox, false);
                setter.setPortValue(bouncelet.inPickMode, PickMode.LogScale);
                setter.setPortValue(bouncelet.inMerging, true);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        Fastest("Fastest"){

            public void apply(PhaseLockedVocoder bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setOverlap(PowerOf2.p2);
                setter.setPortValue(bouncelet.inPeakCount, 80);
                setter.setPortValue(bouncelet.inFastApprox, true);
                setter.setPortValue(bouncelet.inPickMode, PickMode.LogScale);
                setter.setPortValue(bouncelet.inMerging, false);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        Rhythm("Rhythm"){

            public void apply(PhaseLockedVocoder bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p2048);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(bouncelet.inPeakCount, 100);
                setter.setPortValue(bouncelet.inFastApprox, false);
                setter.setPortValue(bouncelet.inPickMode, PickMode.LogScale);
                setter.setPortValue(bouncelet.inMerging, true);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        LegacyFast("LegacyFast"){

            public void apply(PhaseLockedVocoder bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setOverlap(PowerOf2.p2);
                setter.setPortValue(bouncelet.inPeakCount, (Integer)bouncelet.inPeakCount.getMaxValue());
                setter.setPortValue(bouncelet.inFastApprox, true);
                setter.setPortValue(bouncelet.inPickMode, PickMode.Amplitude);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        LegacyNormal("LegacyNormal"){

            public void apply(PhaseLockedVocoder bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(bouncelet.inPeakCount, (Integer)bouncelet.inPeakCount.getMaxValue());
                setter.setPortValue(bouncelet.inFastApprox, false);
                setter.setPortValue(bouncelet.inPickMode, PickMode.Amplitude);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        LegacyHighQuality("LegacyHighQuality"){

            public void apply(PhaseLockedVocoder bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setOverlap(PowerOf2.p16);
                setter.setPortValue(bouncelet.inPeakCount, (Integer)bouncelet.inPeakCount.getMaxValue());
                setter.setPortValue(bouncelet.inFastApprox, false);
                setter.setPortValue(bouncelet.inPickMode, PickMode.Amplitude);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.HannShrink4);
            }
        }
        ,
        GoodQuality("Good Quality"){

            public void apply(PhaseLockedVocoder bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setOverlap(PowerOf2.p8);
                setter.setPortValue(bouncelet.inPeakCount, 400);
                setter.setPortValue(bouncelet.inFastApprox, false);
                setter.setPortValue(bouncelet.inPickMode, PickMode.LogScale);
                setter.setPortValue(bouncelet.inMerging, true);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        HighQuality("High Quality"){

            public void apply(PhaseLockedVocoder bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setOverlap(PowerOf2.p16);
                setter.setPortValue(bouncelet.inPeakCount, 500);
                setter.setPortValue(bouncelet.inFastApprox, false);
                setter.setPortValue(bouncelet.inPickMode, PickMode.LogScale);
                setter.setPortValue(bouncelet.inMerging, true);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        BestQuality("Best Quality"){

            public void apply(PhaseLockedVocoder bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setOverlap(PowerOf2.p32);
                setter.setPortValue(bouncelet.inPeakCount, 400);
                setter.setPortValue(bouncelet.inFastApprox, false);
                setter.setPortValue(bouncelet.inPickMode, PickMode.LogScale);
                setter.setPortValue(bouncelet.inMerging, true);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.HannShrink4);
            }
        };

        private final String name;

        private Preset(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

