/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.common.dsp.UnityRoots;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Log;

public class PitchShiftOcean
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input Spectrum");
    public InDouble inRatio = new InDouble("ratio", "Ratio between desired and original pitches", 1.0, 0.5, 2.0);
    public InSpectrumPreset<PitchShiftOcean, Preset> inPreset = new InSpectrumPreset(Preset.class, "Presets", "Predefined settings", Preset.Normal);
    public InPowerOf2 inZeroPadding = new InPowerOf2(true, "zeroPadding", "Zero padding factor", PowerOf2.p1, PowerOf2.p1, PowerOf2.p64);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output Spectrum");
    private transient int curPhase;
    private transient int nbPhases;
    private transient Cmplx work = Cmplx.newCmplx();
    private Cmplx[] roots;
    private WindowInfo windowing;

    public PitchShiftOcean() {
        super("audio.effect.spectrum.pitch.pitchshift-ocean", "Change the musical pitch without affecting the speed");
        super.setSkillType(SkillType.ADVANCED);
        this.inRatio.setScaleType(ScaleType.LOG2);
        this.inRatio.setSkillType(SkillType.SIMPLIFIED);
        this.inZeroPadding.setSkillType(SkillType.ADVANCED);
    }

    public void reset() {
        super.reset();
        this.curPhase = 0;
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.peek();
        int overlapFactor = inData.windowing.getOverlapping().intValue();
        int intPadFactor = ((PowerOf2)((Object)this.inZeroPadding.read())).intValue();
        int padFactor = inData.windowing.getZeroPadding().intValue() * intPadFactor;
        int nbPhases = overlapFactor * padFactor;
        boolean nbPhasesModified = nbPhases != this.nbPhases;
        boolean ratioModified = this.inRatio.isModified();
        if (nbPhasesModified) {
            this.nbPhases = nbPhases;
            this.roots = UnityRoots.getInstance().getRoots(nbPhases, nbPhases);
        }
        double ratio = (Double)this.inRatio.read();
        if (nbPhasesModified || ratioModified || inData.windowing.windowLength() != this.windowing.windowLength()) {
            assert (inData.windowing.cycleLength() == 1) : "Not implemented";
            this.curPhase = 0;
            this.setupWindows(inData.windowing.getWindow(), ratio, inData.windowing.getOverlapping(), padFactor);
            this.windowing.setWindowModified(true);
        } else {
            this.windowing.setWindowModified(false);
        }
        int outBins = (inData.nbBins - 1) * intPadFactor + 1;
        this.outSpectrum.prepare(inData.nbChannels, outBins, inData.nbLayers, inData.hqxMode, null);
    }

    private void process() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.peek();
        int extPadFactor = inData.windowing.getZeroPadding().intValue();
        int intPadFactor = ((PowerOf2)((Object)this.inZeroPadding.read())).intValue();
        int fullPadFactor = extPadFactor * intPadFactor;
        double ratio = (Double)this.inRatio.read();
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        int chan = 0;
        while (chan < outData.nbChannels) {
            Cmplx[] in = inData.data[chan];
            Cmplx[] out = outData.data[chan];
            out[0].set(in[0]);
            int i = 1;
            while (i < out.length) {
                out[i].set(0.0f, 0.0f);
                ++i;
            }
            i = extPadFactor;
            while (i < in.length) {
                int ip = i * intPadFactor;
                int k = (int)((double)ip * ratio + 0.5);
                if (k > 0 && k < out.length) {
                    int cycleSkew;
                    int phaseSkew;
                    this.work.set(in[i]);
                    if (fullPadFactor > 1) {
                        this.work.mul(fullPadFactor);
                    }
                    if ((phaseSkew = this.curPhase * (cycleSkew = ip > k ? (ip - k) % this.nbPhases : this.nbPhases - (k - ip) % this.nbPhases) % this.nbPhases) != 0) {
                        this.work.mul(this.roots[phaseSkew]);
                    }
                    out[k].add(this.work);
                }
                i += extPadFactor;
            }
            ++chan;
        }
        this.windowing.setWindow(this.windowing.getWindowCycle()[this.curPhase]);
        outData.windowing = this.windowing;
        this.curPhase = (this.curPhase + 1) % this.nbPhases;
    }

    private void setupWindows(float[] inWindow, double ratio, PowerOf2 overlapping, int padFactor) {
        Log.debug("Setup pitchshift windows, ratio {0}", ratio);
        int windowSize = inWindow.length;
        float[][] windowCycle = new float[this.nbPhases][windowSize];
        int floorRatio = (int)(ratio *= (double)padFactor);
        int ceilRatio = floorRatio + 1;
        float ceilAmount = (float)ratio - (float)floorRatio;
        int phase = 0;
        while (phase < this.nbPhases) {
            int floorMinus1 = (floorRatio + (this.nbPhases - padFactor)) % this.nbPhases;
            int floorShift = (int)((long)windowSize * (long)phase * (long)floorMinus1 / (long)this.nbPhases);
            int ceilMinus1 = (ceilRatio + (this.nbPhases - padFactor)) % this.nbPhases;
            int ceilShift = (int)((long)windowSize * (long)phase * (long)ceilMinus1 / (long)this.nbPhases);
            float[] outWindow = windowCycle[phase];
            int i = 0;
            while (i < windowSize) {
                int floorIndex = (i * floorRatio / padFactor + floorShift) % windowSize;
                int ceilIndex = (i * ceilRatio / padFactor + ceilShift) % windowSize;
                float w1 = inWindow[floorIndex];
                float w2 = inWindow[ceilIndex];
                outWindow[i] = w1 * (1.0f - ceilAmount) + w2 * ceilAmount;
                ++i;
            }
            ++phase;
        }
        this.windowing = new WindowInfo(null, overlapping);
        this.windowing.setZeroPadding(PowerOf2.fromInt(padFactor));
        this.windowing.setWindowCycle(windowCycle);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Preset implements Presetter<PitchShiftOcean>
    {
        LowLatency{

            public void apply(PitchShiftOcean b, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p512);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(b.inZeroPadding, PowerOf2.p4);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        Rhythm{

            public void apply(PitchShiftOcean b, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p1024);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(b.inZeroPadding, PowerOf2.p2);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        Normal{

            public void apply(PitchShiftOcean b, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p2048);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(b.inZeroPadding, PowerOf2.p1);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        Melody{

            public void apply(PitchShiftOcean b, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setOverlap(PowerOf2.p8);
                setter.setPortValue(b.inZeroPadding, PowerOf2.p1);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        Fastest{

            public void apply(PitchShiftOcean b, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p2048);
                setter.setOverlap(PowerOf2.p2);
                setter.setPortValue(b.inZeroPadding, PowerOf2.p1);
                setter.setAnalysisWindow(WindowType.Hann);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        BestTradeOff{

            public void apply(PitchShiftOcean b, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p2048);
                setter.setOverlap(PowerOf2.p16);
                setter.setPortValue(b.inZeroPadding, PowerOf2.p2);
                setter.setAnalysisWindow(WindowType.Kaiser50);
                setter.setSynthesisWindow(WindowType.Hann);
            }
        }
        ,
        Canon{

            public void apply(PitchShiftOcean b, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p65536);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(b.inZeroPadding, PowerOf2.p1);
                setter.setAnalysisWindow(WindowType.Rectangular);
                setter.setSynthesisWindow(WindowType.Triangular);
            }
        };

    }
}

